% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimationfunctions.R
\name{monotone_smoother}
\alias{monotone_smoother}
\title{Calculate a monotone probability mass function estimate
using a  rearrangement or a Grenander estimator as described in Jankoswski,
Wellner, 2009 <doi:10.1214/09-EJS526>}
\usage{
monotone_smoother(values, method = "rear", range = c(1, max(values)))
}
\arguments{
\item{values}{observed values of distribution}

\item{method}{method of estimation "rear" rearrangement or "gren" Grenander}

\item{range}{boundaries of the support of the distribution}
}
\value{
vector of estimated pmf (support of distribution is by default assumed to be min(values):max(values) )
}
\description{
Calculate a monotone probability mass function estimate
using a  rearrangement or a Grenander estimator as described in Jankoswski,
Wellner, 2009 <doi:10.1214/09-EJS526>
}
\examples{

# generate sample from geometric distribution
A <- rgeom(50, 0.2)
# plot empirical probability mass function
plot(epmf(A))
dist.A.gren <- monotone_smoother(A, method = "gren")
# plot estimated probability mass function
points(dist.A.gren, col = "red")

}
