% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/currencies.R
\name{exchange_rate_latest}
\alias{exchange_rate_latest}
\title{Retrieve the latest exchange rates between the provided currency code}
\usage{
exchange_rate_latest(currency)
}
\arguments{
\item{currency}{A currency code (see currencies() for supported codes)}
}
\value{
A data.frame containing the latest exchange rates between the provided currency code
    and each other available currency
}
\description{
Retrieve the latest exchange rates between the provided currency code
}
\examples{
\dontrun{

exchange_rate_latest("AUD")
# Daily AUD exchange rate as at end of day 2020-07-27 GMT
#     currency one_aud_is_equivalent_to
# 1        AED                  2.61894
# 2        AFN                 54.47724
# 3        ALL                 75.51799
# 4        AMD                343.40193
# 5        ANG                  1.26829
# 6        AOA                400.54604


# Defaults to USD
exchange_rate_latest()
#     currency one_USD_is_equivalent_to
# 1        AED                   3.6730
# 2        AFN                  76.4035
# 3        ALL                 105.9129
# 4        AMD                 481.6162
# 5        ANG                   1.7788
# 6        AOA                 561.7599

# It can also accept other base rates
exchange_rate_latest("AUD")
#    currency one_AUD_is_equivalent_to
# 1       AED                  2.31619
# 2       AFN                 48.69229
# 3       ALL                 63.87806
# 4       AMD                260.72150
# 5       ANG                  1.13675
# 6       AOA                522.76772
}

}
