% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/primes.R
\name{prime}
\alias{generate_primes}
\alias{is_prime}
\alias{prime}
\title{Generate and Test for Prime Numbers}
\usage{
is_prime(x)

generate_primes(min = 0, max)
}
\arguments{
\item{x}{an integer vector containing elements you want to determine the primality of.}

\item{min}{the value to generate primes from.}

\item{max}{the maximum value to generate prime numbers up to.}
}
\description{
generate prime numbers or test whether a sequence of numbers you have are
prime or not.
}
\details{
\code{is_prime} and \code{generate_primes} rely on Wilson's theorem to test for a number's primality;
as primality algorithms go, this is actually a very \emph{slow} approach - in theory. In practice, because of the
limits R institutes around integer sizes, it's fast enough for our needs. For example, 10m numbers, all 2^30-sized,
can be tested for primality using this package in 100ms.
}
\examples{
#Test for primality
is_prime(1299827)
# [1] TRUE

generate_primes(max =12)
# [1]  2  3  5  7 11
}

