% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/problem.R
\name{problem}
\alias{problem}
\title{Create mathematical model}
\usage{
problem(
  x,
  model_type = "minimizeCosts",
  budget = 0,
  blm = 0,
  curve = 1,
  segments = 3
)
}
\arguments{
\item{x}{\linkS4class{data} object. Data used in a problem of
prioritization of multiple conservation actions. This object must be created using the
\code{\link[=problem]{problem()}} function.}

\item{model_type}{\code{character}. Name of the type of model to create. With two possible values:
\code{minimizeCosts} and \code{maximizeBenefits}.}

\item{budget}{\code{numeric}. Maximum budget allowed. This field is used only if a
model of the type \code{maximizeBenefits} is applied.}

\item{blm}{\code{numeric}. Weight factor applied to the sum of connectivity penalties
for missed connections in a solution, similar to Boundary Length Modifier (BLM) in \emph{Marxan}. This argument
only has an effect when the \code{boundary} is available.}

\item{curve}{\code{integer}. Type of continuous curve used to represent benefit expression. It can
be a linear (\code{1}), quadratic (\code{2}) or cubic (\code{3}) function.
See \strong{Details} for more information.}

\item{segments}{\code{integer}. Number of segments (\code{1}, \code{2}, \code{3}, \code{4} or \code{5}) used to approximate the non-linear
expression (\code{curve}) in the calculate benefits. See \strong{Details} for more information.}
}
\value{
An object of class \linkS4class{optimizationProblem}.
}
\description{
Create an optimization model for the multi-action conservation
planning problem, following the mathematical formulations used in
Salgado-Rojas \emph{et al.} (2020).
}
\details{
Currently the problem function allows you to create two types of mathematical programming models:
\describe{
\item{\strong{minimize cost (minimizeCosts)}:}{ This model seeks to find the set of actions that
minimizes the overall planning costs, while meeting a set of representation targets
for the conservation features.

This model can be expressed mathematically for a set of planning units
\eqn{I} indexed by \eqn{i} a set of features \eqn{S} indexed by \eqn{s}, and
a set of threats \eqn{K} indexed by \eqn{k} as:
\deqn{
\min \space \sum_{i \in I}\sum_{k \in K_i} x_{ik} c_{ik} + \sum_{i \in I} x_{i \cdot} c'_{i} + blm \cdot connectivity\\
\mathit{s.t.} \\
\sum_{i \in I_s} p_{is} r_{is} \geq t_s \space \forall \space s \in S
}
Where, \eqn{x_{ik}} is a decisions variable that specifies whether an action to abate
threat \eqn{k} in planning unit \eqn{i} has been selected (1) or not (0), \eqn{c_{ik}}
is the cost of the action to abate the threat \eqn{k} in the planning unit \eqn{i},
\eqn{c'_{i}} is the monitoring cost of planning unit \eqn{i},
\eqn{p_{is}} is the probability of persistence of the feature \eqn{s} in the planning unit \eqn{i}
(ranging between 0 and 1), \eqn{r_{is}} is the amount of
feature \eqn{s} in planning unit \eqn{i}. \eqn{t_s} is the \strong{recovery target} for feature \eqn{s}.
In the case of working with \strong{conservation target}, the following constraint is necessary:

\deqn{
\sum_{i \in I_s: |K_{s} \cap K_{i}| \neq 0} z_{is} r_{is} \geq t'_s \space \forall \space s \in S
}
With, \eqn{z_{is}}  as the probability of persistence by conservation of the feature s in the planning unit i
(ranging between 0 and 1). It is only present when there is no spatial co-occurrence between
a feature and its threats (i.e. \eqn{|K_{s} \cap K_{i}| \neq 0}). In the case of binary threat
intensities it is assumed as 1.  \eqn{t'_s} is the
\strong{conservation target} for feature \eqn{s}.
}

\item{\strong{maximize benefits (maximizeBenefits)}:}{ The maximize benefits model seeks
to find the set of actions that maximizes the sum of benefits of
all features, while the cost of performing actions and monitoring does not exceed a certain budget.
Using the terminology presented above, this model can be expressed mathematically as:

\deqn{
\max \space \sum_{i \in I}\sum_{s \in S_i} b_{is} - blm \cdot connectivity\\
\mathit{s.t.} \\
\sum_{i \in I} \sum_{k \in K_i} x_{ik} c_{ik} + \sum_{i \in I} x_{i \cdot} c'_{i} \leq budget
}

}}

Where \eqn{b_{is}} is the benefit of the feature \eqn{s} in a planning unit \eqn{i} and it
is calculated by multiplying the probability of persistence of the feature in the
unit by its corresponding amount, i.e., \eqn{b_{is} = p_{is} r_{is}}. When we talk about
recovering, the probability of persistence is a measure of the number of actions taken against the threats that
affect said feature. For more information on its calculation, see the
\code{getSolutionBenefit()} or \code{getPotentialBenefit()} functions references.

As a way of including the risk associated with calculating our probability of
persistence of the features and in turn, avoiding that many low probabilities
of persistence end up reaching the proposed targets, is that we add the \code{curve}
parameter. That incorporates an exponent (values of 1: linear, 2: quadratic
or 3: cubic) to the calculation of the probability of persistence. Thus penalizing
the low probabilities in the sum of the benefits achieved.
Since \code{prioriactions} works with linear models, we use a piecewise linearization strategy to
work with non-linear curves in \eqn{b_{is}}. The \code{segments} parameter indicates how well the expression
approximates the curved used in \eqn{b_{is}}. A higher number implies a better
approximation but increases the resolution complexity. Note that for a linear curve
(\code{curve} = 1) it is not necessary to set a \code{segment} parameter.

Parameters \code{blm} and \code{blm_actions} allow controlling the spatial connectivity
of the selected units and of the deployed actions, respectively (similar to BLM in Marxan).
}
\examples{
## This example uses input files included into package.

## set seed for reproducibility
set.seed(14)

## Load data
data(sim_pu_data, sim_features_data, sim_dist_features_data,
sim_threats_data, sim_dist_threats_data, sim_sensitivity_data,
sim_boundary_data)

## Create data instance
problem_data <- inputData(
  pu = sim_pu_data, features = sim_features_data, dist_features = sim_dist_features_data,
  threats = sim_threats_data, dist_threats = sim_dist_threats_data,
  sensitivity = sim_sensitivity_data, boundary = sim_boundary_data
)

## Create minimizeCosts model
model_min <- problem(x = problem_data, blm = 1, model_type = "minimizeCosts")

#' ## Create maximazeBenefits model
model_max <- problem(x = problem_data, model_type = "maximizeBenefits", budget = 100)
}
\seealso{
For more information regarding the arguments
\code{curve} and \code{segments}, see the supplementary material
of Salgado-Rojas \emph{et al.} (2020)..
}
