% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getActions.R
\name{getActions}
\alias{getActions}
\title{Extract action information}
\usage{
getActions(x, format = "wide")
}
\arguments{
\item{x}{\linkS4class{solution} or \linkS4class{portfolio} object.}

\item{format}{\code{character}. Output format of the action matrix; \code{wide} format
shows one column per action, while \code{large} format shows four columns: solution_name, pu,
action and solution.}
}
\value{
\link{data.frame}.
}
\description{
Returns the spatial deployment of the actions for each planning unit of
the corresponding solution.
}
\details{
\code{getActions()} function assumes that actions can be of three types:
\enumerate{
\item \strong{to abate specific threats}: these actions have the \emph{id} corresponding
to the threat to be abate.
\item \strong{to conservation}: that indicates if the planning unit is selected to
conservative any feature that is not threatened.
\item \strong{to connectivity}: that indicates if the planning
unit is selected only by connectivity (i.e. without performing conservation actions
or actions against a threat in said unit).
}
}
\examples{
\donttest{
# set seed for reproducibility
set.seed(14)

## Load data
data(sim_pu_data, sim_features_data, sim_dist_features_data,
sim_threats_data, sim_dist_threats_data, sim_sensitivity_data,
sim_boundary_data)

## Create instance
problem_data <- inputData(
  pu = sim_pu_data, features = sim_features_data, dist_features = sim_dist_features_data,
  threats = sim_threats_data, dist_threats = sim_dist_threats_data,
  sensitivity = sim_sensitivity_data, boundary = sim_boundary_data
)

## Create optimization model
problem_model <- problem(x = problem_data)

## Solve the optimization model
s <- solve(a = problem_model, time_limit = 2, output_file = FALSE, cores = 2)

# get actions information in large format
actions <- getActions(s, format = "large")
head(actions)

# get actions information in wide format
actions <- getActions(s, format = "wide")
head(actions)
}

}
