% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_relative_targets.R
\docType{methods}
\name{add_relative_targets}
\alias{add_relative_targets}
\alias{add_relative_targets-method}
\alias{add_relative_targets,ConservationProblem,numeric-method}
\alias{add_relative_targets,ConservationProblem,character-method}
\alias{add_relative_targets}
\alias{add_relative_targets}
\alias{add_relative_targets}
\title{Add Relative Targets}
\usage{
\S4method{add_relative_targets}{ConservationProblem,numeric}(x, targets, ...)

\S4method{add_relative_targets}{ConservationProblem,character}(x, targets, ...)
}
\arguments{
\item{x}{\code{\link{ConservationProblem-class}} object.}

\item{targets}{\code{numeric} targets for features. If all features should
have the same target, \code{targets} can be a single number. Otherwise,
\code{targets} should be a \code{numeric} \code{vector} specifying a
target for each feature. Alternatively, if the features in
\code{x} were specified using a \code{data.frame} object, then
argument to \code{targets} may refer to a column name.}

\item{...}{not used.}
}
\value{
\code{\link{ConservationProblem-class}} object with the target added
  to it.
}
\description{
Set targets as a proportion (between 0 and 1) of the maximum level of
representation of features in the study area. The argument to \code{x}
should have a single value if all features have the same target. Otherwise,
the vector should have a value for each feature. In this case, targets are
assigned to features based on their position in the argument to \code{x}
and the \code{feature} when specifying the problem.
}
\details{
Note that with the exception of the maximum cover problem, targets must
be added to a \code{\link{problem}} or solving will return an error.


Targets are used to specify the minimum amount or proportion of a feature's
distribution that needs to be protected. All conservation planning problems
require adding targets with the exception of the maximum cover problem
(see \code{\link{add_max_cover_objective}}), which maximizes all features
in the solution and therefore does not require targets.
}
\examples{
# load data
data(sim_pu_raster, sim_features)

# create base problem
p <- problem(sim_pu_raster, sim_features) \%>\%
     add_min_set_objective() \%>\%
     add_binary_decisions()

# create problem with 10 \% targets
p1 <- p \%>\% add_relative_targets(0.1)

# create problem with varying targets for each feature
targets <- c(0.1, 0.2, 0.3, 0.4, 0.5)
p2 <- p \%>\% add_relative_targets(targets)
\donttest{
# solve problem
s <- stack(solve(p1), solve(p2))

# plot solution
plot(s, main = c("10 \% targets", "varying targets"), axes = FALSE,
     box = FALSE)
}

}
\seealso{
\code{\link{targets}}.
}
