% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_cuts_portfolio.R
\name{add_cuts_portfolio}
\alias{add_cuts_portfolio}
\title{Add Bender's cuts portfolio}
\usage{
add_cuts_portfolio(x, number_solutions = 10L)
}
\arguments{
\item{x}{\code{\link{ConservationProblem-class}} object.}

\item{number_solutions}{\code{integer} number of attempts to generate
different solutions. Defaults to 10.}
}
\value{
\code{\link{ConservationProblem-class}} object with the portfolio
  added to it.
}
\description{
Generate a portfolio of solutions for a conservation planning
\code{\link{problem}} using Bender's cuts (discussed in Rodrigues
\emph{et al.} 2000).
}
\details{
This strategy for generating a portfolio of solutions involves
  solving the problem multiple times and adding additional constraints
  to forbid previously obtained solutions. In general, this strategy is most
  useful when problems take a long time to solve and benefit from
  having multiple threads allocated for solving an individual problem.
  \strong{Please note that version 4.0.1 attempted to use the \emph{Gurobi}
  solution pool to speed up the process of obtaining multiple solutions.
  However, it would sometimes return solutions that were not within the
  specified optimality gap. To address this, all solution pool methods are
  provided by the \code{\link{add_pool_portfolio}} function.}
}
\examples{
# set seed for reproducibility
set.seed(500)

# load data
data(sim_pu_raster, sim_features, sim_pu_zones_stack, sim_features_zones)

# create minimal problem with cuts portfolio
p1 <- problem(sim_pu_raster, sim_features) \%>\%
      add_min_set_objective() \%>\%
      add_relative_targets(0.2) \%>\%
      add_cuts_portfolio(10) \%>\%
      add_default_solver(gap = 0.2, verbose = FALSE)

\donttest{
# solve problem and generate 10 solutions within 20 \% of optimality
s1 <- solve(p1)

# plot solutions in portfolio
plot(stack(s1), axes = FALSE, box = FALSE)
}
# build multi-zone conservation problem with cuts portfolio
p2 <- problem(sim_pu_zones_stack, sim_features_zones) \%>\%
      add_min_set_objective() \%>\%
      add_relative_targets(matrix(runif(15, 0.1, 0.2), nrow = 5,
                                  ncol = 3)) \%>\%
      add_binary_decisions() \%>\%
      add_cuts_portfolio(10) \%>\%
      add_default_solver(gap = 0.2, verbose = FALSE)

\donttest{
# solve the problem
s2 <- solve(p2)

# print solution
str(s2, max.level = 1)

# plot solutions in portfolio
plot(stack(lapply(s2, category_layer)), main = "solution", axes = FALSE,
     box = FALSE)
}
}
\references{
Rodrigues AS, Cerdeira OJ, and Gaston KJ (2000) Flexibility,
efficiency, and accountability: adapting reserve selection algorithms to
more complex conservation problems. \emph{Ecography}, 23: 565--574.
}
\seealso{
\code{\link{portfolios}}.
}
