% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_semicontinuous_decisions.R
\name{add_semicontinuous_decisions}
\alias{add_semicontinuous_decisions}
\title{Add semi-continuous decisions}
\usage{
add_semicontinuous_decisions(x, upper_limit)
}
\arguments{
\item{x}{\code{\link[=problem]{problem()}} (i.e. \code{\linkS4class{ConservationProblem}}) object.}

\item{upper_limit}{\code{numeric} value specifying the maximum proportion
of a planning unit that can be reserved (e.g. set to 0.8 for 80\%).}
}
\value{
Object (i.e. \code{\linkS4class{ConservationProblem}}) with the decisions added
to it.
}
\description{
Add a semi-continuous decision to a conservation planning
\code{\link[=problem]{problem()}}. This is a relaxed decision where a part of a planning
unit can be prioritized, as opposed to the entire planning unit, which is
the default function (see \code{\link[=add_binary_decisions]{add_binary_decisions()}}).
This decision is similar to the \code{\link[=add_proportion_decisions]{add_proportion_decisions()}}
function except that it has an upper bound parameter. By default, the
decision can range from prioritizing none (0\%) to all (100\%) of a
planning unit. However, an upper bound can be specified to ensure that at
most only a fraction (e.g. 80\%) of a planning unit can be preserved. This
type of decision may be useful when it is not practical to conserve entire
planning units.
}
\details{
Conservation planning problems involve making decisions on planning
units. These decisions are then associated with actions (e.g. turning a
planning unit into a protected area). Only a
single decision should be added to a \code{ConservationProblem} object.
Note that if multiple decisions are added to a problem object, then the
last one to be added will be used.
}
\examples{
# set seed for reproducibility
set.seed(500)

# load data
data(sim_pu_raster, sim_features, sim_pu_zones_stack, sim_features_zones)

# create minimal problem with semi-continuous decisions
p1 <- problem(sim_pu_raster, sim_features) \%>\%
      add_min_set_objective() \%>\%
      add_relative_targets(0.1) \%>\%
      add_semicontinuous_decisions(0.5) \%>\%
      add_default_solver(verbose = FALSE)
\dontrun{
# solve problem
s1 <- solve(p1)

# plot solutions
plot(s1, main = "solution")
}
# build multi-zone conservation problem with semi-continuous decisions
p2 <- problem(sim_pu_zones_stack, sim_features_zones) \%>\%
      add_min_set_objective() \%>\%
      add_relative_targets(matrix(runif(15, 0.1, 0.2), nrow = 5,
                                  ncol = 3)) \%>\%
      add_semicontinuous_decisions(0.5) \%>\%
      add_default_solver(verbose = FALSE)
\dontrun{
# solve the problem
s2 <- solve(p2)

# print solution
print(s2)

# plot solution
# panels show the proportion of each planning unit allocated to each zone
plot(s2, axes = FALSE, box = FALSE)
}
}
\seealso{
See \link{decisions} for an overview of all functions for adding decisions.

Other decisions: 
\code{\link{add_binary_decisions}()},
\code{\link{add_default_decisions}()},
\code{\link{add_proportion_decisions}()}
}
\concept{decisions}
