% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_data}
\alias{simulate_data}
\title{Simulate data}
\usage{
simulate_data(
  x,
  n = 1,
  scale = 0.5,
  intensity = 0,
  sd = 1,
  transform = identity
)
}
\arguments{
\item{x}{\code{\link[raster:raster]{raster::raster()}} raster object to use as a template.}

\item{n}{\code{integer} number of layers to simulate.
Defaults to 1.}

\item{scale}{\code{numeric} parameter to control level of spatial
auto-correlation.
Defaults to 0.5.}

\item{intensity}{\code{numeric} average value of simulated data.
Defaults to 0.}

\item{sd}{\code{numeric} standard deviation of simulated data.
Defaults to 1.}

\item{transform}{\code{function} transform values output from the simulation.
Defaults to the \code{\link[=identity]{identity()}} function such that values remain the same
following transformation.}
}
\value{
\code{\link[raster:stack]{raster::stack()}} object.
}
\description{
Simulate spatially auto-correlated data using Gaussian random fields.
}
\examples{
\dontrun{
# create raster
r <- raster(ncol = 10, nrow = 10, xmn = 0, xmx = 1, ymn = 0, ymx = 1)
values(r) <- 1

# simulate data using a Gaussian field
x <- simulate_data(r, n = 1, scale = 0.2)

# plot simulated data
plot(x, main = "simulated data")
}
}
