% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_shuffle_portfolio.R
\name{add_shuffle_portfolio}
\alias{add_shuffle_portfolio}
\title{Add a shuffle portfolio}
\usage{
add_shuffle_portfolio(
  x,
  number_solutions = 10,
  threads = 1,
  remove_duplicates = TRUE
)
}
\arguments{
\item{x}{\code{\link[=problem]{problem()}} object.}

\item{number_solutions}{\code{integer} number of attempts to generate
different solutions. Defaults to 10.}

\item{threads}{\code{integer} number of threads to use for the generating
the solution portfolio. Defaults to 1.}

\item{remove_duplicates}{\code{logical} should duplicate solutions
be removed? Defaults to \code{TRUE}.}
}
\value{
An updated \code{\link[=problem]{problem()}} object with the portfolio added to it.
}
\description{
Generate a portfolio of solutions for a conservation planning
problem by randomly reordering the data prior to
solving the problem. Although this function can be useful for generating
multiple different solutions for a given problem,
it is recommended to use \link{add_pool_portfolio} if the \emph{Gurobi}
software is available.
}
\details{
This strategy for generating a portfolio of solutions often
results in different solutions, depending on optimality gap, but may
return duplicate solutions. In general, this strategy is most effective
when problems are quick to solve and multiple threads are available for
solving each problem separately.
}
\examples{
\dontrun{
# set seed for reproducibility
set.seed(500)

# load data
sim_pu_raster <- get_sim_pu_raster()
sim_features <- get_sim_features()
sim_zones_pu_raster <- get_sim_zones_pu_raster()
sim_zones_features <- get_sim_zones_features()

# create minimal problem with shuffle portfolio
p1 <-
  problem(sim_pu_raster, sim_features) \%>\%
  add_min_set_objective() \%>\%
  add_relative_targets(0.2) \%>\%
  add_shuffle_portfolio(10, remove_duplicates = FALSE) \%>\%
  add_default_solver(gap = 0.2, verbose = FALSE)

# solve problem and generate 10 solutions within 20\% of optimality
s1 <- solve(p1)

# convert portfolio into a multi-layer raster
s1 <- terra::rast(s1)

# print number of solutions found
print(terra::nlyr(s1))

# plot solutions in portfolio
plot(s1, axes = FALSE)

# build multi-zone conservation problem with shuffle portfolio
p2 <-
  problem(sim_zones_pu_raster, sim_zones_features) \%>\%
  add_min_set_objective() \%>\%
  add_relative_targets(matrix(runif(15, 0.1, 0.2), nrow = 5, ncol = 3)) \%>\%
  add_binary_decisions() \%>\%
  add_shuffle_portfolio(10, remove_duplicates = FALSE) \%>\%
  add_default_solver(gap = 0.2, verbose = FALSE)

# solve the problem
s2 <- solve(p2)

# convert each solution in the portfolio into a single category layer
s2 <- terra::rast(lapply(s2, category_layer))

# print number of solutions found
print(terra::nlyr(s2))

# plot solutions in portfolio
plot(s2, axes = FALSE)
}
}
\seealso{
See \link{portfolios} for an overview of all functions for adding a portfolio.

Other portfolios: 
\code{\link{add_cuts_portfolio}()},
\code{\link{add_default_portfolio}()},
\code{\link{add_extra_portfolio}()},
\code{\link{add_gap_portfolio}()},
\code{\link{add_top_portfolio}()}
}
\concept{portfolios}
