\name{pm.getGenesByProbe}
\alias{pm.getGenesByProbe}
\title{Gets a list of the genes associated with the specified probe...}
\usage{pm.getGenesByProbe(conn, probeID, platformID, probeName, authorityID)}
\description{Gets a list of the genes associated with the specified probe}
\value{a list containing information about the probe specified and a data.frame detailing the genes with which 
this probe is associated. There is a normalized [0-1] value representing the strength of that association according 
to each authority in the database.}
\author{Jeffrey D. Allen \email{Jeffrey.Allen@UTSouthwestern.edu}}
\arguments{\item{conn}{the connection object generated by pm.connect()}
\item{probeID}{the internal probeID used to uniquely reference probes}
\item{platformID}{the ID of the platform associated with the probe name.}
\item{probeName}{the name of the probe, as assigned by the vendor, for this platformID.}
\item{authorityID}{a number of vector of numbers representing the ID(s) of the authorities (sources) 
which you want to use to map this probe to genes. At the time of writing, 1 = BLAST, 2 = Vendor, 3 = Bioconductor.}}
