% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/jn.R
\name{jn}
\alias{jn}
\title{Johnson-Neyman Technique}
\usage{
jn(model, dv, iv, mod, alpha = 0.05)
}
\arguments{
\item{model}{regression model (lm).}

\item{dv}{dependent variable (character).}

\item{iv}{independent variable (character).}

\item{mod}{moderator variable(s) (character or character vector).}

\item{alpha}{alpha level to use (numeric).}
}
\value{
A list with the elements
}
\description{
Probe moderation effect using the Johnson-Neyman technique
}
\examples{
\dontrun{
myModel <- lm('DV ~ IV + MOD', data=someData)
jnresults <- jn(myModel, dv='DV', iv='IV', mod='MOD')
jnresults <- jn(myModel, dv='DV', iv='IV', mod='MOD', alpha=.01)
plot(jnresults)
}
}
\references{
Spiller, S. A., Fitzsimons, G. J., Lynch, J. G., Jr, & McClelland, G. H. (2013). Spotlights, floodlights, and the magic number zero: Simple effects tests in moderated regression. Journal of Marketing Research, 50(2), 277-288.

Bauer, D. J., & Curran, P. J. (2005). Probing interactions in fixed and multilevel regression: Inferential and graphical techniques. Multivariate Behavioral Research, 40(3), 373-400.
}

