% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordinateProfiles.R
\name{coordinateProfiles}
\alias{coordinateProfiles}
\title{Coordinate profiles starting from a kriging model}
\usage{
coordinateProfiles(object, threshold, options_full = NULL,
  options_approx = NULL, uq_computations = FALSE, plot_level = 0,
  plot_options = NULL, CI_const = NULL, return_level = 1, ...)
}
\arguments{
\item{object}{either a \link[DiceKriging]{km} model or a list containing partial results. If \code{object} is a km model then all computations are carried out. If \code{object} is a list, then the function carries out all computations to complete the list results.}

\item{threshold}{the threshold of interest}

\item{options_full}{an optional list of options for getAllMaxMin, see \link{getAllMaxMin} for details.}

\item{options_approx}{an optional list of options for approxMaxMin, see \link{approxMaxMin} for details.}

\item{uq_computations}{boolean, if TRUE the uq computations for the profile mean are computed.}

\item{plot_level}{an integer to select the plots to return (0=no plots, 1=basic plots, 2= all plots)}

\item{plot_options}{an optional list of parameters for plots. See \link{setPlotOptions} for currently available options.}

\item{CI_const}{an optional vector containing the constants for the CI. If not NULL, then profiles extrema for \eqn{m_n(x) \pm CI_const[i]*s_n(x,x)} are computed.}

\item{return_level}{an integer to select the amount of details returned}

\item{...}{additional parameters to be passed to \link{coordProf_UQ}.}
}
\value{
If return_level=1 a list containing
\itemize{
\item{\code{profMean_full:}}{the results of \code{getAllMaxMin} for the posterior mean}
\item{\code{profMean_approx:}}{the results of \code{approxMaxMin} for the posterior mean}
\item{\code{res_UQ:}}{the results of \code{coordProf_UQ} for the posterior mean}
}
if return_level=2 the same list as above but also including
\itemize{
\item{\code{abs_err:}}{the vector of maximum absolute approximation errors for the profile inf /sup on posterior mean for the chosen approximation}
\item{\code{times:} }{ a list containing
	\itemize{
	\item{\code{full:}}{computational time for the full computation of profile extrema}
	\item{\code{approx:}}{computational time for the approximate computation of profile extrema}
	}}
}
}
\description{
The function coordinateProfiles computes the profile extrema functions for the posterior mean of a Gaussian process and its confidence bounds
}
\examples{
if (!requireNamespace("DiceKriging", quietly = TRUE)) {
stop("DiceKriging needed for this example to work. Please install it.",
     call. = FALSE)
}
# Compute a kriging model from 50 evaluations of the Branin function
# Define the function
g=function(x){
  return(-branin(x))
}
gp_des<-lhs::maximinLHS(20,2)
reals<-apply(gp_des,1,g)
kmModel<-km(design = gp_des,response = reals,covtype = "matern3_2")

threshold=-10

# Compute coordinate profiles on the posterior mean
options_full<-list(multistart=4,heavyReturn=TRUE, Design = replicate(2,seq(0,1,,60)))
init_des<-lhs::maximinLHS(15,2)
options_approx<- list(multistart=4,heavyReturn=TRUE,initDesign=init_des,fullDesignSize=60)
cProfilesMean<-coordinateProfiles(object=kmModel,threshold=threshold,options_full=options_full,
                                  options_approx=options_approx,uq_computations=FALSE,
                                  plot_level=3,plot_options=NULL,CI_const=NULL,return_level=2)
\dontrun{
# Coordinate profiles with UQ with approximate profiles
plot_options<-list(save=FALSE, titleProf = "Coordinate profiles",
                   title2d = "Posterior mean",qq_fill=TRUE)
cProfilesUQ<-coordinateProfiles(object=cProfilesMean,threshold=threshold,options_full=options_full,
                                  options_approx=options_approx,uq_computations=TRUE,
                                  plot_level=3,plot_options=NULL,CI_const=NULL,return_level=2)

# Coordinate profiles with UQ with fully optim profiles
options_full_sims<-list(multistart=4,heavyReturn=TRUE, Design = replicate(2,seq(0,1,,60)))
cProfilesUQ<-coordinateProfiles(object=cProfilesMean,threshold=threshold,options_full=options_full,
                                  options_approx=options_approx,uq_computations=TRUE,
                                  plot_level=3,plot_options=NULL,CI_const=NULL,return_level=2,
                                  options_full_sims=options_full_sims)
}
}
\author{
Dario Azzimonti
}
