% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handler_progress.R
\name{handler_progress}
\alias{handler_progress}
\title{Progression Handler: Progress Reported via 'progress' Progress Bars (Text) in the Terminal}
\usage{
handler_progress(
  format = ":spin [:bar] :percent :message",
  show_after = 0,
  intrusiveness = getOption("progressr.intrusiveness.terminal", 1),
  target = "terminal",
  ...
)
}
\arguments{
\item{format}{(character string) The format of the progress bar.}

\item{show_after}{(numeric) Number of seconds to wait before displaying
the progress bar.}

\item{intrusiveness}{(numeric) A non-negative scalar on how intrusive
(disruptive) the reporter to the user.}

\item{target}{(character vector) Specifies where progression updates are
rendered.}

\item{\ldots}{Additional arguments passed to \code{\link[=make_progression_handler]{make_progression_handler()}}.}
}
\description{
A progression handler for \code{\link[progress:progress_bar]{progress::progress_bar()}}.
}
\section{Requirements}{

This progression handler requires the \pkg{progress} package.
}

\section{Appearance}{

Below is how this progress handler renders by default at 0\%, 30\% and 99\%
progress:

With \code{handlers(handler_progress())}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{- [-------------------------------------------------]   0\% 
\\ [====>--------------------------------------------]  10\% 
| [================================================>]  99\% 
}\if{html}{\out{</div>}}

If the progression updates have messages, they will appear like:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{- [-----------------------------------------]   0\% Starting
\\ [===========>----------------------------]  30\% Importing
| [=====================================>]  99\% Summarizing
}\if{html}{\out{</div>}}
}

\examples{
if (requireNamespace("progress", quietly = TRUE)) {

  handlers(handler_progress(format = ":spin [:bar] :percent :message"))
  with_progress({ y <- slow_sum(1:10) })
  print(y)
  
}
}
