% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handler_pbcol.R
\name{handler_pbcol}
\alias{handler_pbcol}
\title{Progression Handler: Progress Reported as an ANSI Background Color in the Terminal}
\usage{
handler_pbcol(
  adjust = 0,
  pad = 1L,
  complete = function(s) crayon::bgBlue(crayon::white(s)),
  incomplete = function(s) crayon::bgCyan(crayon::white(s)),
  intrusiveness = getOption("progressr.intrusiveness.terminal", 1),
  target = "terminal",
  ...
)
}
\arguments{
\item{adjust}{(numeric) The adjustment of the progress update,
where \code{adjust = 0} positions the message to the very left, and
\code{adjust = 1} positions the message to the very right.}

\item{pad}{(integer) Amount of padding on each side of the message,
where padding is done by spaces.}

\item{complete, incomplete}{(function) Functions that take "complete" and
"incomplete" strings that comprise the progress bar as input and annotate
them to reflect their two different parts.  The default is to annotation
them with two different background colors and the same foreground color
using the \pkg{crayon} package.}

\item{intrusiveness}{(numeric) A non-negative scalar on how intrusive
(disruptive) the reporter to the user.}

\item{target}{(character vector) Specifies where progression updates are
rendered.}

\item{\ldots}{Additional arguments passed to \code{\link[=make_progression_handler]{make_progression_handler()}}.}
}
\description{
Progression Handler: Progress Reported as an ANSI Background Color in the Terminal
}
\section{Requirements}{

This progression handler requires the \pkg{crayon} package.
}

\examples{
handlers(handler_pbcol)
with_progress({ y <- slow_sum(1:10) })
print(y)
}
