% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R
\name{get_dates}
\alias{get_dates}
\alias{get_dates.default}
\alias{get_dates.projections}
\title{Access content projections objects}
\usage{
get_dates(x, ...)

\method{get_dates}{default}(x, ...)

\method{get_dates}{projections}(x, ...)
}
\arguments{
\item{x}{A \code{projections} object.}

\item{...}{Further arguments passed to methods; currently not used.}
}
\description{
These simple helper functions retrieve content from \code{projections}
objects. They currently include:
}
\details{
\itemize{
 \item \code{get_dates}: get dates of the predictions.

}
}
\examples{


if (require(distcrete) && require(incidence)) {

## prepare input: epicurve and serial interval
dat <- c(0, 2, 2, 3, 3, 5, 5, 5, 6, 6, 6, 6)
i <- incidence(dat)
si <- distcrete("gamma", interval = 1L,
                 shape = 1.5,
                 scale = 2, w = 0)


## make predictions
pred_1 <- project(i, 1.2, si, n_days = 30)
pred_1


## retrieve content
get_dates(pred_1)
max(i$dates) # predictions start 1 day after last incidence

}

}
\author{
Thibaut Jombart \email{thibautjombart@gmail.com}
}
