% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getters.R
\name{affiliations}
\alias{affiliations}
\alias{authors}
\alias{display_metadata}
\alias{projects}
\alias{ideas}
\alias{manuscripts}
\title{View the \code{projects()}, \code{authors()}, and \code{affiliations()}
tables}
\usage{
affiliations(affiliation, authors = FALSE)

authors(author, affiliations = FALSE, projects = FALSE)

projects(
  project,
  all_stages = FALSE,
  exclude = c(0L, 6L),
  path = NULL,
  archived = FALSE,
  verbose = FALSE,
  authors = FALSE
)

ideas(project, archived = FALSE, verbose = FALSE, authors = FALSE)

manuscripts(project, archived = FALSE, verbose = FALSE, authors = FALSE)
}
\arguments{
\item{projects, authors, affiliations}{Logical values indicating whether or not
to perform a left join with another metadata tibble. All \code{FALSE} by
default.}

\item{project, author, affiliation}{An optional unique vector of \code{id}s
and/or names. Only rows matching one or more entries will be returned. This
is the one setting in which the package does not return throw an error if
user input matches multiple projects.}

\item{all_stages}{Logical, indicating whether or not to include projects of
all stages, \strong{overriding the} \code{exclude} \strong{argument}.}

\item{exclude}{A vector of numbers or character strings that can be validated
  against the list of project stages:

  \code{0: idea}\cr \code{1: design}\cr \code{2: data collection}\cr \code{3:
  analysis}\cr \code{4: manuscript}\cr \code{5: under review}\cr \code{6:
  accepted}

  \emph{Ignored if} \code{all_stages = TRUE}}

\item{path}{A single file path of a directory within the main projects
folder; only projects whose folder is in this directory will be returned.}

\item{archived}{Logical, indicating whether or not to include projects that
have been archived using \code{\link{archive_project}()}. \code{FALSE} by
default.}

\item{verbose}{Logical, indicating whether or not to return all columns of
the \code{\link{projects}()}; if \code{FALSE}, only the \code{id},
\code{current_owner}, \code{status}, and \code{stage} columns are returned.
Defaults to \code{FALSE}.}
}
\value{
A \code{\link[tibble]{tibble}}.
}
\description{
Returns a table of the projects/authors/affiliations, filtered and joined
according to the entirely optional arguments.
}
\details{
\code{ideas()} is a shortcut for \code{projects(exclude = 1:6)} (including
only projects of stage \code{0: idea}).

\code{manuscripts()} is a shortcut for \code{projects(exclude = c(0:3, 6))}
(yielding only projects of stage \code{4: manuscript} and \code{5: under
review}).

If one or more of the \code{projects}, \code{authors}, or \code{affiliations}
arguments is set to \code{TRUE}, a \code{dplyr::\link[dplyr]{left_join}()} is
performed, with the "left" table being the one sharing the name of the
function being used. As such, rows that don't have matches in any other
tables will still show up in the output, and rows that have multiple matches
in other tables will yield multiple rows in the output. The "right" table's
\code{id} column will be renamed.
}
\examples{
#############################################################################
# SETUP
old_home <- Sys.getenv("HOME")
old_ppath <- Sys.getenv("PROJECTS_FOLDER_PATH")
temp_dir <- tempfile("dir")
dir.create(temp_dir)
Sys.unsetenv("PROJECTS_FOLDER_PATH")
Sys.setenv(HOME = temp_dir)
setup_projects(path = temp_dir)
new_affiliation(department_name = "Math Dept.",
                institution_name = "Springfield College",
                address = "123 College St, Springfield, AB")
new_affiliation(department_name = "Art Department",
                institution_name = "Springfield College",
                address = "321 University Boulevard, Springfield, AB",
                id = 42)
new_affiliation(department_name = "Central Intelligence Agency",
                institution_name = "United States Government",
                address = "888 Classified Dr, Washington DC")
new_affiliation(department_name = "Pyrotechnics",
                institution_name = "ACME")
new_author(given_names = "Spiro", last_name = "Agnew", degree = "LLB",
           affiliations = "Art D", id = 13)
new_author(given_names = "Plato", id = 303)
new_author(given_names = "Condoleezza", last_name = "Rice",
           affiliations = c(1, 42, "Agency", "ACME"))
new_project(title = "Test project 1", current_owner = "Plato", stage = 1)
new_project(title = "Test project 2", current_owner = "eezza", stage = 2)
new_project(title = "Test project 3", current_owner = "Plato", stage = 3)
new_project(title = "Fun project 4",  current_owner = "Rice", stage = 4)
new_project(title = "Fun project 5",  current_owner = "Rice", stage = 5)
new_project(title = "Fun project 6",  current_owner = "Rice", stage = 6)
new_project(title = "Good idea",  current_owner = "Rice", stage = 0)
#############################################################################

# View entire affiliations table
affiliations()

# View authors table joined to affiliations table
# Notice that multiple rows are created for each affiliation-author combination
authors(affiliations = TRUE)

# View only active projects with "Fun" in their title.
projects("Fun")

# View all projects with "Rice" as the current_owner
projects(all_stages = TRUE) \%>\% dplyr::filter(current_owner == "Rice")

# View manuscripts
manuscripts()

# View ideas
ideas()

# Wrapped in if (interactive()) because it requires interactive console input
# and fails automated testing.
if (interactive()) {
  # Archive Fun project 5
  archive_project("Fun project 5")

  # Default behavior is to not include archived projects in projects() table
  projects("Fun")
  projects("Fun", archived = TRUE)
}

#############################################################################
# CLEANUP
# (or, the user can just restart R)
Sys.setenv(HOME = old_home, PROJECTS_FOLDER_PATH = old_ppath)
}
