% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listcol.R
\name{listcol_extract}
\alias{listcol_extract}
\title{Extract new dataframe column from list-column matching pattern}
\usage{
listcol_extract(data, col_name, regex, new_col_name = NULL,
  keep_regex = FALSE)
}
\arguments{
\item{data}{Dataframe containing a list column (e.g. an issues dataframe)}

\item{col_name}{Character string containing column name of list column (e.g. \code{labels_name} or \code{assignees_login})}

\item{regex}{Character string of regular expression to identify list items of interest (e.g. \code{"^priority:", "^(bug|feature)$"})}

\item{new_col_name}{Optional name of new column. Otherwise \code{regex} is used, stripped of any leading or trailing punctuation}

\item{keep_regex}{Optional logical denoting whether to keep regex part of matched item in value. Defaults to \code{FALSE}}
}
\value{
Dataframe with new column taking values extracted from list column
}
\description{
Creaes a new column in your dataframe based on a subset of list-column values following a certain patten. For example,
this is useful if you have labels you always apply to a repository with a set structure, e.g. key-value pairs like "priority:high",
"priority:medium", and "priority:low" or other structures like "engagement-team", "teaching-team", etc. This function could
create a new variable (e.g. "priority", "team") with the values encoded within the labels.
}
\details{
This function works only if each observatino contains at most one instance of a given patterns. When multiple labels match the
same pattern, one is returned at random.
}
\examples{
\dontrun{
issues <- get_issues(repo)
issues_df <- parse_issues(issues)
listcol_extract(issues_df, "labels_name", "-team$")
}
}
