% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viz-waterfall.R
\name{viz_waterfall}
\alias{viz_waterfall}
\title{Visualize waterfall of opened, closed, and pending items over timeframe}
\usage{
viz_waterfall(
  data,
  start_date,
  end_date,
  start = "created_at",
  end = "closed_at"
)
}
\arguments{
\item{data}{Dataset, such as those representing issues or milestones (i.e. \code{parse_issues()} or
\code{parse_milestones()}). Must have \code{state} variable and variables to specify for
\code{start} and \code{end}}

\item{start_date}{Character string in 'YYYY-MM-DD' form for first date to be considered (inclusive)}

\item{end_date}{Character string in 'YYYY-MM-DD' form for last date to be considered (inclusive)}

\item{start}{Unquoted variable name denoting issue start date}

\item{end}{Unquoted variable name denoting issue end date}
}
\value{
ggplot object
}
\description{
Creates a four-bar waterfall diagram. Within the specified timeframe, shows initial,
newly opened, newly closed, and final open counts. Works with either issues or milestones,
as obtained by the \code{get} and \code{parse} functions.
}
\details{
The following logic is used to classify issues:

\itemize{
\item Initial: \verb{start < start_date and (end > start_date or state == 'open')}
\item Open: \verb{start >= start_date and start <= end_date}
\item Closed: \verb{end >= start_date and end <= end_date}
\item Final: \verb{start < end_date and (end > end_date or state == 'open')}
}

The exact accuracy of the logic depends on filtering that has already been done to the dataset. Think carefully
about the population you wish to represent when \code{get}ting your data.
}
\examples{
\dontrun{
viz_waterfall(milestones, '2017-01-01', '2017-03-31')
}
}
\seealso{
Other issues: 
\code{\link{get_issue_comments}()},
\code{\link{get_issue_events}()},
\code{\link{get_issues}()},
\code{\link{parse_issue_comments}()},
\code{\link{parse_issue_events}()},
\code{\link{parse_issues}()},
\code{\link{post_issue_update}()},
\code{\link{post_issue}()},
\code{\link{report_discussion}()},
\code{\link{report_progress}()}
}
\concept{issues}
