% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prophet.R
\name{prophet}
\alias{prophet}
\title{Prophet forecast.}
\usage{
prophet(df = df, growth = "linear", changepoints = NULL,
  n.changepoints = 25, yearly.seasonality = TRUE,
  weekly.seasonality = TRUE, holidays = NULL,
  seasonality.prior.scale = 10, changepoint.prior.scale = 0.05,
  holidays.prior.scale = 10, mcmc.samples = 0, interval.width = 0.8,
  uncertainty.samples = 1000, fit = TRUE)
}
\arguments{
\item{df}{Data frame with columns ds (date type) and y, the time series.
If growth is logistic, then df must also have a column cap that specifies
the capacity at each ds.}

\item{growth}{String 'linear' or 'logistic' to specify a linear or logistic
trend.}

\item{changepoints}{Vector of dates at which to include potential
changepoints. Each date must be present in df$ds. If not specified,
potential changepoints are selected automatically.}

\item{n.changepoints}{Number of potential changepoints to include. Not used
if input `changepoints` is supplied. If `changepoints` is not supplied,
then n.changepoints potential changepoints are selected uniformly from the
first 80 percent of df$ds.}

\item{yearly.seasonality}{Boolean, fit yearly seasonality.}

\item{weekly.seasonality}{Boolean, fit weekly seasonality.}

\item{holidays}{data frame with columns holiday (character) and ds (date
type)and optionally columns lower_window and upper_window which specify a
range of days around the date to be included as holidays.}

\item{seasonality.prior.scale}{Parameter modulating the strength of the
seasonality model. Larger values allow the model to fit larger seasonal
fluctuations, smaller values dampen the seasonality.}

\item{changepoint.prior.scale}{Parameter modulating the flexibility of the
automatic changepoint selection. Large values will allow many changepoints,
small values will allow few changepoints.}

\item{holidays.prior.scale}{Parameter modulating the strength of the holiday
components model.}

\item{mcmc.samples}{Integer, if great than 0, will do full Bayesian
inference with the specified number of MCMC samples. If 0, will do MAP
estimation.}

\item{interval.width}{Numeric, width of the uncertainty intervals provided
for the forecast. If mcmc.samples=0, this will be only the uncertainty
in the trend using the MAP estimate of the extrapolated generative model.
If mcmc.samples>0, this will be integrated over all model parameters,
which will include uncertainty in seasonality.}

\item{uncertainty.samples}{Number of simulated draws used to estimate
uncertainty intervals.}

\item{fit}{Boolean, if FALSE the model is initialized but not fit.}
}
\value{
A prophet model.
}
\description{
Prophet forecast.
}
\examples{
\dontrun{
history <- data.frame(ds = seq(as.Date('2015-01-01'), as.Date('2016-01-01'), by = 'd'),
                      y = sin(1:366/200) + rnorm(366)/10)
m <- prophet(history)
}

}

