% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/113.ConfidenceIntervals_ADJ_n_x.R
\name{ciATWx}
\alias{ciATWx}
\title{AdjustedWALD-T method of CI estimation}
\usage{
ciATWx(x, n, alp, h)
}
\arguments{
\item{x}{- Number of successes}

\item{n}{- Number of trials}

\item{alp}{- Alpha value (significance level required)}

\item{h}{- Adding factor}
}
\value{
A dataframe with
 \item{x}{  Number of successes (positive samples)}
 \item{LATWx }{   T-Wald Lower limit}
 \item{UATWx }{   T-Wald Upper Limit}
 \item{LABB }{   T-Wald Lower Abberation}
 \item{UABB }{   T-Wald Upper Abberation}
 \item{ZWI }{   Zero Width Interval}
}
\description{
AdjustedWALD-T method of CI estimation
}
\details{
Given data \code{x} and \code{n} are modified as \eqn{x + h} and \eqn{n + (2*h)}
 respectively, where \eqn{h > 0} then approximate method based on a t_approximation of the
 standardized point estimator for the given \code{x} and \code{n}.
}
\examples{
x=5; n=5; alp=0.05;h=2
ciATWx(x,n,alp,h)
}
\references{
[1] 1998 Agresti A and Coull BA.
Approximate is better than "Exact" for interval estimation of binomial proportions.
The American Statistician: 52; 119 - 126.

[2] 1998 Newcombe RG.
Two-sided confidence intervals for the single proportion: Comparison of seven methods.
Statistics in Medicine: 17; 857 - 872.

[3] 2008 Pires, A.M., Amado, C.
Interval Estimators for a Binomial Proportion: Comparison of Twenty Methods.
REVSTAT - Statistical Journal, 6, 165-197.
}
\seealso{
\code{\link{prop.test} and \link{binom.test}} for equivalent base Stats R functionality,
   \code{\link[binom]{binom.confint}}  provides similar functionality for 11 methods,
   \code{\link[PropCIs]{wald2ci}} which provides multiple functions for CI calculation ,
   \code{\link[BlakerCI]{binom.blaker.limits}} which calculates Blaker CI which is not covered here and
   \code{\link[prevalence]{propCI}} which provides similar functionality.

Other Adjusted methods of CI estimation  given x & n: \code{\link{PlotciAAllx}},
  \code{\link{ciAASx}}, \code{\link{ciAAllx}},
  \code{\link{ciALRx}}, \code{\link{ciALTx}},
  \code{\link{ciASCx}}, \code{\link{ciAWDx}}
}
