% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{prism}
\alias{prism}
\title{Make Prism Plot}
\usage{
prism(rho, k, prompt = TRUE)
}
\arguments{
\item{rho}{A \code{propr} object created from \code{\link{perb}}.}

\item{k}{A numeric scalar. The number of groups into which to
cluster the subjects. Clusters calculated  using \code{hclust}.
Optional parameter for \code{\link{bucket}}, \code{\link{prism}},
and \code{\link{bokeh}}.}

\item{prompt}{A logical scalar. Set to \code{FALSE} to disable
the prompt when plotting a large number of features.}
}
\value{
Returns cluster membership if \code{k} is provided.
}
\description{
Plots the variance of the ratio of the log-ratio transformed
 feature pair (vlr) versus the sum of the individual variances
 of each log-ratio transformed feature (vls). The ratio of
 the vlr to the vls equals \code{1 - rho}. As such, we use
 here seven rainbow colored lines to indicate where \code{rho}
 equals \code{[.01, .05, .50, 0, 1.50, 1.95, 1.99]}, going
 from red to violet.
}
\details{
Providing the argument \code{k} will color feature pairs
 by co-cluster membership. In other words, a feature pair
 will receive a color if and only if both features belong
 to same the cluster (calculated using \code{hclust}).
}

