% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_peptide_type.R
\name{qc_peptide_type}
\alias{qc_peptide_type}
\title{Check peptide type percentage share}
\usage{
qc_peptide_type(
  data,
  sample,
  peptide,
  pep_type,
  intensity,
  remove_na_intensities = TRUE,
  method = "count",
  plot = FALSE,
  interactive = FALSE
)
}
\arguments{
\item{data}{a data frame that contains at least the input columns.}

\item{sample}{a character column in the \code{data} data frame that contains the sample names.}

\item{peptide}{a character column in the \code{data} data frame that contains the peptide
sequence.}

\item{pep_type}{a character column in the \code{data} data frame that contains the peptide
type. Can be obtained using the \code{find_peptide} and \code{assign_peptide_type} function
together.}

\item{intensity}{a numeric column in the \code{data} data frame that contains the corresponding
raw or normalised intensity values (not log2) for each peptide or precursor. Required when
"intensity" is chosen as the method.}

\item{remove_na_intensities}{a logical value that specifies if sample/peptide combinations with
intensities that are NA (not quantified IDs) should be dropped from the data frame for analysis
of peptide type distributions. Default is TRUE since we are usually interested in the peptide
type distribution of quantifiable IDs. This is only relevant for method = "count".}

\item{method}{a character value that indicates the method used for evaluation.
\code{method = "intensity"} calculates the peptide type percentage by intensity, whereas
\code{method = "count"} calculates the percentage by peptide ID count. Default is
\code{method = count}.}

\item{plot}{a logical value that indicates whether the result should be plotted.}

\item{interactive}{a logical value that indicates whether the plot should be interactive.}
}
\value{
A data frame that contains the calculated percentage shares of each peptide type per
sample. The \code{count} column contains the number of peptides with a specific type. The
\code{peptide_type_percent} column contains the percentage share of a specific peptide type.
}
\description{
Calculates the percentage share of each peptide types (fully-tryptic, semi-tryptic,
non-tryptic) for each sample.
}
\examples{
# Load libraries
library(dplyr)

set.seed(123) # Makes example reproducible

# Create example data
data <- create_synthetic_data(
  n_proteins = 100,
  frac_change = 0.05,
  n_replicates = 3,
  n_conditions = 2,
  method = "effect_random"
) \%>\%
  mutate(intensity_non_log2 = 2^peptide_intensity_missing)

# Determine peptide type percentages
qc_peptide_type(
  data = data,
  sample = sample,
  peptide = peptide,
  pep_type = pep_type,
  intensity = intensity_non_log2,
  method = "intensity",
  plot = FALSE
)

# Plot peptide type
qc_peptide_type(
  data = data,
  sample = sample,
  peptide = peptide,
  pep_type = pep_type,
  intensity = intensity_non_log2,
  method = "intensity",
  plot = TRUE
)
}
