% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/provenance.R
\name{getKDEs}
\alias{getKDEs}
\title{Generate an object of class \code{KDEs}}
\usage{
getKDEs(x, from = NA, to = NA, bw = NA, samebandwidth = TRUE,
  adaptive = TRUE, pch = NA, normalise = FALSE, log = FALSE)
}
\arguments{
\item{x}{an object of class \code{DZdata}}

\item{from}{minimum limit of the x-axis.}

\item{to}{maximum limit of the x-axis.
#'}

\item{bw}{the bandwidth of the kernel density estimates. If bw =
NULL, the bandwidth will be set automatically using \code{botev()}}

\item{samebandwidth}{boolean flag indicating whether the same
bandwidth should be used for all samples. If samebandwidth = TRUE
and bw = NULL, then the function will use the median bandwidth of
all the samples.}

\item{adaptive}{boolean flag switching on the adaptive bandwidth
modifier of Abramson (1982)}

\item{pch}{(optional) symbol to be used to mark the sample points along the x-axis}

\item{normalise}{boolean flag indicating whether or not the KDEs
should all integrate to the same value.}

\item{log}{boolean flag indicating whether the data should by
plotted on a logarithmic scale.}
}
\description{
Convert a dataset of class \code{DZdata} into an object of
class \code{KDEs} for further processing by the
\code{summaryplot} function.
}
\examples{
fname <- system.file("DZ.csv",package="provenance")
DZ <- read.DZdata(fname)
KDEs <- getKDEs(DZ,0,3000,pch=NA)
summaryplot(KDEs,ncol=3)
}

