% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.GPA}
\alias{plot.GPA}
\title{Plot a Procrustes configuration}
\usage{
\method{plot}{GPA}(x, pch = NA, pos = NULL, col = "black", bg = "white",
  cex = 1, ...)
}
\arguments{
\item{x}{an object of class \code{GPA}}

\item{pch}{plot symbol}

\item{pos}{position of the sample labels relative to the plot
symbols if pch != NA}

\item{col}{plot colour (may be a vector)}

\item{bg}{background colour (may be a vector)}

\item{cex}{relative size of plot symbols}

\item{...}{optional arguments to the generic \code{plot} function}
}
\description{
Plots the group configuration of a Generalised Procrustes Analysis
}
\examples{
data(Namib)
GPA <- procrustes(Namib$DZ,Namib$HM)
coast <- c('N1','N2','N3','N10','N11','N12','T8','T13')
snames <- names(Namib$DZ)
bgcol <- rep('yellow',length(snames))
bgcol[which(snames \%in\% coast)] <- 'red'
plot(GPA,pch=21,bg=bgcol)
}
\seealso{
procrustes
}
