% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toolbox.R
\name{procrustes}
\alias{procrustes}
\title{Generalised Procrustes Analysis of provenance data}
\usage{
procrustes(...)
}
\arguments{
\item{...}{a sequence of datasets of classes \code{distributional}
and \code{compositional}}
}
\value{
an object of class \code{GPA}, i.e. a list containing the
following items:

\code{points}: a two column vector with the coordinates of the
group configuration

\code{labels}: a list with the sample names
}
\description{
Given a number of input datasets, this function performs an MDS
analysis on each of these and the feeds the resulting
configurations into the \code{GPA()} function.
}
\examples{
data(Namib)
gpa <- procrustes(Namib$DZ,Namib$HM)
plot(gpa)
}
\references{
Gower, J.C. (1975). Generalized Procrustes analysis,
Psychometrika, 40, 33-50.
}
\seealso{
GPA
}
\author{
Pieter Vermeesch
}
