% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gui.R, R/provenance.R
\docType{package}
\name{provenance}
\alias{provenance}
\alias{_PACKAGE}
\alias{provenance-package}
\title{Menu-based interface for \code{provenance}}
\usage{
provenance()
}
\description{
For those less familiar with the syntax of the \code{R} programming
language, the \code{provenance()} function provides a user-friendly
way to access the most important functionality in the form of a
menu-based query interface. Further details and examples are
provided on \url{https://www.ucl.ac.uk/~ucfbpve/provenance/}

\code{provenance} provides statistical tools to interpret large
amounts of distributional (single grain analyses) and compositional
(mineralogical and bulk chemical) data from the command line, or
using a menu-based user interface.
}
\details{
A list of documented functions may be viewed by typing
\code{help(package='provenance')}.  Detailed instructions are
provided at \url{https://www.ucl.ac.uk/~ucfbpve/provenance/} and in
the Sedimentary Geology paper by Vermeesch, Resentini and Garzanti
(2016).
}
\references{
Vermeesch, P., Resentini, A. and Garzanti, E., an R
    package for statistical provenance analysis, Sedimentary
    Geology, doi:10.1016/j.sedgeo.2016.01.009.

Vermeesch, P., Resentini, A. and Garzanti, E., 2016, An
    R package for statistical provenance analysis, Sedimentary
    Geology, 336, 14-25.
}
\seealso{
\url{https://www.ucl.ac.uk/~ucfbpve/provenance/}

Useful links:
\itemize{
  \item \url{https://www.ucl.ac.uk/~ucfbpve/provenance/}
}

}
\author{
Pieter Vermeesch

\strong{Maintainer}: Pieter Vermeesch \email{p.vermeesch@ucl.ac.uk}

}
