% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kill-tree.R
\name{ps_mark_tree}
\alias{ps_mark_tree}
\alias{with_process_cleanup}
\alias{ps_kill_tree}
\title{Mark a process and its (future) child tree}
\usage{
ps_mark_tree()

with_process_cleanup(expr)

ps_kill_tree(marker, sig = signals()$SIGKILL)
}
\arguments{
\item{expr}{R expression to evaluate in the new context.}

\item{marker}{String scalar, the name of the environment variable to
use to find the marked processes.}

\item{sig}{The signal to send to the marked processes on Unix. On
Windows this argument is ignored currently.}
}
\value{
\code{ps_mark_tree()} returns the name of the environment variable,
which can be used as the \code{marker} in \code{ps_kill_tree()}.

\code{ps_kill_tree()} returns the pids of the killed processes, in a named
integer vector. The names are the file names of the executables, when
available.

\code{with_process_cleanup()} returns the value of the evaluated expression.
}
\description{
\code{ps_mark_tree()} generates a random environment variable name and sets
it in the  current R process. This environment variable will be (by
default) inherited by all child (and grandchild, etc.) processes, and
will help finding these processes, even if and when they are (no longer)
related to the current R process. (I.e. they are not connected in the
process tree.)
}
\details{
\code{ps_kill_tree()} finds the processes that set the supplied environment
variable, and kills them (or sends them the specified signal on Unix).

\code{with_process_cleanup()} evaluates an R expression, and cleans up all
external processes that were started by the R process while evaluating
the expression. This includes child processes of child processes, etc.,
recursively.
}
\keyword{internal}
