% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_exponential.R
\docType{class}
\name{PriorExponential-class}
\alias{PriorExponential-class}
\alias{.prior_exponential}
\title{\code{PriorExponential} Class}
\description{
A class for defining exponential priors to be translated to Stan code.
Objects of class \code{PriorExponential} should not be created directly but by
the constructor \code{\link[=prior_exponential]{prior_exponential()}}.
}
\section{Slots}{

\describe{
\item{\code{stan_code}}{character. Stan implementation of the prior, with
placeholders for exponential Stan function parameters surrounded with
\verb{\{\{} and \verb{\}\}} to be replaced with \code{\link[glue:glue]{glue::glue()}}.}

\item{\code{n_param}}{integer. Number of prior parameters (1).}

\item{\code{constraint}}{character. Support of prior distribution,
\code{"<lower=0>"}.}

\item{\code{beta}}{numeric. Inverse scale (>0).}
}}

\seealso{
Other prior classes: 
\code{\link{Prior-class}},
\code{\link{PriorBernoulli-class}},
\code{\link{PriorBeta-class}},
\code{\link{PriorCauchy-class}},
\code{\link{PriorGamma-class}},
\code{\link{PriorHalfCauchy-class}},
\code{\link{PriorHalfNormal-class}},
\code{\link{PriorNormal-class}},
\code{\link{PriorPoisson-class}},
\code{\link{UniformPrior-class}}
}
\concept{prior classes}
