% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_normal.R
\docType{class}
\name{PriorNormal-class}
\alias{PriorNormal-class}
\alias{.prior_normal}
\title{\code{PriorNormal} Class}
\description{
A class for defining normal priors to be translated to Stan code.
Objects of class \code{PriorNormal} should not be created directly but by
the constructor \code{\link[=prior_normal]{prior_normal()}}.
}
\section{Slots}{

\describe{
\item{\code{stan_code}}{character. Stan implementation of the prior, with
placeholders for normal stan function parameters surrounded with
\verb{\{\{} and \verb{\}\}} to be replaced with \code{\link[glue:glue]{glue::glue()}}.}

\item{\code{n_param}}{integer. Number of prior parameters (2).}

\item{\code{constraint}}{character. Support of prior distribution,
(all values allowed in normal distribution).}

\item{\code{mu}}{numeric. Location.}

\item{\code{sigma}}{numeric. Scale (>0).}
}}

\seealso{
Other prior classes: 
\code{\link{Prior-class}},
\code{\link{PriorBernoulli-class}},
\code{\link{PriorBeta-class}},
\code{\link{PriorCauchy-class}},
\code{\link{PriorExponential-class}},
\code{\link{PriorGamma-class}},
\code{\link{PriorHalfCauchy-class}},
\code{\link{PriorHalfNormal-class}},
\code{\link{PriorPoisson-class}},
\code{\link{UniformPrior-class}}
}
\concept{prior classes}
