% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data_baseline.R
\name{set_transformations,BaselineObject-method}
\alias{set_transformations,BaselineObject-method}
\title{Set Transformations in Baseline Objects}
\usage{
\S4method{set_transformations}{BaselineObject}(object, ..., overwrite = FALSE)
}
\arguments{
\item{object}{\code{BaselineObject} created by \link{create_baseline_object}.}

\item{...}{named transformation functions. See details for more information.}

\item{overwrite}{If \code{TRUE} overwrite existing transformation list and only include newly specified transformations.}
}
\value{
An updated \code{BaselineObject}
}
\description{
Set Transformations in Baseline Objects
}
\details{
Transformation functions are evaluated in order and create or overwrite a column in the data.frame with that
name. The function should have signature \verb{function(data)}, taking a \code{data.frame} (specifically a
\code{BaselineDataFrame} object from \code{generate(BaselineObject)}) and return a vector with length identical to the total
number of patients. The \verb{@BaselineObject} slot of the \linkS4class{BaselineDataFrame} may be accessed directly or with
\code{\link[=get_quantiles]{get_quantiles()}} to create transformations. See \code{\link[=binary_cutoff]{binary_cutoff()}}.
}
\examples{
baseline <- create_baseline_object(
  100, 50, 100,
  covariates = baseline_covariates(
    names = "age", means_int = 55,
    covariance_int = covariance_matrix(5)
  )
)
set_transformations(baseline, age_scaled = function(data) scale(data$age))
}
