% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.plr.R
\name{summary.plr}
\alias{summary.plr}
\title{Summarizing Polygonal Linear Regression}
\usage{
\method{summary}{plr}(object, digits = max(3L, getOption("digits") - 3L),
  ...)
}
\arguments{
\item{object}{an object of the class \code{plr}, usually, a result of a call to \code{\link{plr}}.}

\item{digits}{a non-null value for \code{digits} specifies the minimum number of significant 
digits to be printed in values.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
residuals calculated as the response variable minus the fitted values.

adj.r.squared \eqn{R^2} measure \emph{adjusted} penalizing for higher p.

sigma the square root of the estimated variance of the random error.

call the matched call.

df degrees of freedom.

aliased named logical vector showing if the original coefficients are aliased.

terms the \code{\link[stats]{terms}}.

coefficients a p x 4 matrix with columns for the estimated coefficient, 
its standard error, t-statistic and corresponding (two-sided) p-value.

fstatistics (for models including non-intercept terms) a 3-vector with the value
 the F-statistic with its numerator and denominator degrees of freedom.

r.squared \eqn{R^2}, the fraction of variance explained by the model.
}
\description{
\code{summary} method for class \code{plr}.
}
\examples{
yp <- psim(50, 10) #simulate 50 polygons of 10 sides
xp1 <- psim(50, 10) #simulate 50 polygons of 10 sides
xp2 <- psim(50, 10) #simulate 50 polygons of 10 sides
e <- new.env()
e$yp <- yp
e$xp1 <- xp1
e$xp2 <- xp2
fit <- plr(yp~xp1 + xp2, data = e)
s <- summary(fit) 
}
