% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kepner_robinson.R
\name{kepner_robinson_test_internal}
\alias{kepner_robinson_test_internal}
\title{Kepner-Robinson Test}
\usage{
kepner_robinson_test_internal(
  data,
  time,
  subject,
  distribution,
  na.rm,
  formula = NULL,
  ...
)
}
\arguments{
\item{data}{numeric vector containing the data}

\item{na.rm}{a logical value indicating if NA values should be removed}

\item{formula}{formula object}

\item{...}{further arguments are ignored}

\item{group}{ordered factor vector for the groups}

\item{alternative}{either decreasing or increasing}

\item{trend}{custom numeric vector indicating the trend for the custom alternative, only used if alternative = "custom"}
}
\value{
Returns a data.frame with the results
}
\description{
This function calculates the Kepner-Robinsin test under the null hypothesis H0F: F_1 = ... F_k.
}
\examples{
x = c(1, 1, 1, 1, 2, 3, 4, 5, 6)
grp = as.factor(c('A','A','B','B','B','D','D','D','D'))

# calculate Kruskal-Wallis test using pseudo-ranks
kruskal_wallis_test(x, grp, na.rm = FALSE, pseudoranks = TRUE)
}
\references{
Kepner, J. L., & Robinson, D. H. (1988). Nonparametric methods for detecting treatment effects in repeated-measures designs. Journal of the American Statistical Association, 83(402), 456-461.
}
\keyword{internal}
