% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool_compare_models.R
\name{pool_compare_models}
\alias{pool_compare_models}
\title{Compare the fit and performance of prediction models in Multipy Imputed data}
\usage{
pool_compare_models(
  pobj,
  compare.predictors = NULL,
  compare.group = NULL,
  cutoff = 0.5,
  boot_auc = FALSE,
  nboot = 1000
)
}
\arguments{
\item{pobj}{An object of class \code{pmods} (pooled models), produced by a previous
call to \code{psfmi_lr}.}

\item{compare.predictors}{Character vector with the names of the predictors that are 
compared. See details.}

\item{compare.group}{Character vector with the names of the group of predictors that are 
compared. See details.}

\item{cutoff}{A numerical scalar. Cutoff used for the categorical NRI value. More than one
cutoff value can be used.}

\item{boot_auc}{If TRUE the standard error of the AUC is calculated with stratified
bootstrapping. If FALSE (is default), the standard error is calculated with De Long's
method.}

\item{nboot}{A numerical scalar. The number of bootstrap samples for the AUC standard error, used 
when boot_auc is TRUE. Default is 1000.}
}
\value{
An object from which the following objects can be extracted: 
 \itemize{
 \item  \code{DR_stats} p-value of the D3 statistic, the D3 statistic, LRT fixed is the 
  likelihood Ratio test value of the constrained models.
 \item  \code{stats_compare} Mean of LogLik0, LogLik1, AIC0, AIC1, AIC_diff values of the 
  restricted (containing a 0) and full models (containing a 1).
 \item  \code{NRI} pooled values for the categorical and continuous Net Reclassification
  improvement values and the Integrated Discrimination improvement.
 \item  \code{AUC_stats} Pooled Area Under the Curve of restricted and full models. 
 \item  \code{AUC_diff} Pooled difference in AUC. 
 \item  \code{formula_test} regression formula of full model.
 \item  \code{cutoff} Cutoff value used for reclassification values.
 \item  \code{formula_null} regression formula of null model
 \item  \code{compare_predictors} Predictors used in full model.
 \item  \code{compare_group} group of predictors used in full model.
}
}
\description{
\code{pool_compare_model} Compares the fit and performance of prediction models 
 in multiply imputed data sets by using clinical important performance measures
}
\details{
The fit of the models are compared by using the D3 method for pooling Likelihood ratio 
 statistics (method of Meng and Rubin). The pooled AIC difference is calculated according to
 the formula \code{AIC = D - 2*p}, where D is the pooled likelihood ratio tests of 
 constrained models (numerator in D3 statistic) and p is the difference in number of parameters 
 between the full and restricted models that are compared. The pooled AUC difference  
 is calculated, after the standard error is obtained in each imputed data set by method 
 DeLong or bootstrapping. The NRI categorical and continuous and IDI are calculated in each 
 imputed data set and pooled.
}
\examples{
 pool_lr <- psfmi_lr(data=lbpmilr, p.crit = 1, direction="FW", nimp=10, impvar="Impnr", 
 Outcome="Chronic", predictors=c("Radiation"), cat.predictors = ("Satisfaction"),
 int.predictors = NULL, spline.predictors="Tampascale", nknots=3, method="D1")

 res_compare <- pool_compare_models(pool_lr, compare.predictors = c("Pain", "Duration", 
 "Function"), cutoff = 0.4)
 res_compare

 
}
\references{
Eekhout I, van de Wiel MA, Heymans MW. Methods for significance testing of categorical
  covariates in logistic regression models after multiple imputation: power and applicability
  analysis. BMC Med Res Methodol. 2017;17(1):129.

Consentino F, Claeskens G. Order Selection tests with multiply imputed data
  Computational Statistics and Data Analysis.2010;54:2284-2295.
}
