% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hoslem_test.R
\name{hoslem_test}
\alias{hoslem_test}
\title{Calculates the Hosmer and Lemeshow goodness of fit test.}
\usage{
hoslem_test(y, yhat, g = 10)
}
\arguments{
\item{y}{a vector of observations (0/1).}

\item{yhat}{a vector of predicted probabilities.}

\item{g}{Number of groups tested. Default is 10. Can not be < 3.}
}
\value{
The Chi-squared test statistic, the p-value, the observed and 
 expected frequencies.
}
\description{
\code{hoslem_test} the Hosmer and Lemeshow goodness of fit test.
}
\examples{
  fit <- glm(Mortality ~ Dementia + factor(Mobility) + ASA + 
   Gender + Age, data=hipstudy, family=binomial) 
   pred <- predict(fit, type = "response")
  
  hoslem_test(fit$y, pred)
 
}
\references{
Kleinman K and Horton NJ. (2014). SAS and R: Data Management, 
 Statistical Analysis, and Graphics. 2nd Edition. Chapman & Hall/CRC.
}
\seealso{
\code{\link{pool_performance}}
}
\author{
Martijn Heymans, 2021
}
