% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nri_cox.R
\name{nri_cox}
\alias{nri_cox}
\title{Net Reclassification Index for Cox Regression Models}
\usage{
nri_cox(data, formula0, formula1, t_risk, cutoff, B = FALSE, nboot = 10)
}
\arguments{
\item{data}{Data frame with relevant predictors}

\item{formula0}{A formula object to specify the reference model as normally used by glm.
See under "Details" and "Examples" how these can be specified.}

\item{formula1}{A formula object to specify the new model as normally used by glm.}

\item{t_risk}{Follow-up value to calculate cases, controls. See details.}

\item{cutoff}{A numerical vector that defines the outcome probability cutoff values.}

\item{B}{A logical  scalar. If TRUE bootstrap confidence intervals are calculated, if FALSE only
the NRI estimates are reported.}

\item{nboot}{A numerical scalar. Number of bootstrap samples to derive the percentile bootstrap
confidence intervals. Default is 10.}
}
\value{
An object from which the following objects can be extracted: 
 \itemize{
 \item  \code{data} dataset. 
 \item  \code{prob_orig} outcome risk probabilities at t_risk for reference model.
 \item  \code{prob_new} outcome risk probabilities at t_risk for new model.
 \item  \code{time} name of time variable.
 \item  \code{status} name of status variable.
 \item  \code{cutoff} cutoff value for survival probability. 
 \item  \code{t_risk} follow-up time used to calculate outcome (risk) probabilities.
 \item  \code{reclass_totals} table with total reclassification numbers.
 \item  \code{reclass_cases} table with reclassification numbers for cases.
 \item  \code{reclass_controls} table with reclassification numbers for controls.
 \item  \code{totals} totals of controls, cases, censored cases.
 \item  \code{km_est} totals of cases calculated using Kaplan-Meiers risk estimates.
 \item  \code{nri_est} reclassification measures.
}
}
\description{
\code{nri_cox} Net Reclassification Index for Cox Regression Models
}
\details{
A typical formula object has the form \code{Outcome ~ terms}. Categorical variables has to
 be defined as \code{Outcome ~ factor(variable)}, restricted cubic spline variables as
 \code{Outcome ~ rcs(variable, 3)}. Interaction terms can be defined as
 \code{Outcome ~ variable1*variable2} or \code{Outcome ~ variable1 + variable2 + variable1:variable2}.
 All variables in the terms part have to be separated by a "+". If a formula
 object is used set predictors, cat.predictors, spline.predictors or int.predictors
 at the default value of NULL.
 
 Follow-up for which cases nd controls are determined. For censored cases before this follow-up 
 the expected risk of being a case is calculated by using the Kaplan-Meier value to calculate
 the expected number of cases.These expected numbers are used to calculate the NRI proportions 
 but are not shown by function \code{nricens}.
}
\examples{
  library(survival)
  lbpmicox1 <- subset(psfmi::lbpmicox, Impnr==1) # extract one dataset
  risk_est <- nri_cox(data=lbpmicox1, formula0 = Surv(Time, Status) ~ Duration + Pain,
                   formula1 = Surv(Time, Status) ~ Duration + Pain + Function + Radiation,
                   t_risk = 80, cutoff=c(0.45), B=TRUE, nboot=10)

}
\references{
Cook NR, Ridker PM. Advances in measuring the effect of individual predictors of 
 cardiovascular risk: the role of reclassification measures. Ann Intern Med. 2009;150(11):795-802.

Steyerberg EW, Pencina MJ. Reclassification calculations for persons with incomplete 
 follow-up. Ann Intern Med. 2010;152(3):195-6; author reply 196-7.

Pencina MJ, D'Agostino RB Sr, Steyerberg EW. Extensions of net reclassification 
 improvement calculations to measure usefulness of new biomarkers. Stat Med. 2011;30(1):11-21

Inoue E (2018). nricens: NRI for Risk Prediction Models with Time to Event and Binary 
 Response Data. R package version 1.6, <https://CRAN.R-project.org/package=nricens>.
}
\author{
Martijn Heymans, 2023
}
