% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{quantile.outcomes}
\alias{quantile.outcomes}
\title{Calculate quantiles of model outcome variables}
\usage{
\method{quantile}{outcomes}(data, model, probs, prob.names)
}
\arguments{
\item{data}{data.frame containing predictor variables and outcome variables}

\item{model}{associated model (its formula is used to determine which variables in \code{data} are predictors and which are outcomes)}

\item{probs}{probabilities at which quantiles will be calculated (same as for `quantile`)}

\item{prob.names}{format strings used to construct names of the new data columns. For example, if \code{probs} is 0.05 and
\code{prob.names} is \code{\%s.lower}, then the 5th percentile of each outcome variable \code{var} will be returned in \code{var.lower}.}
}
\value{
data frame of predictors and associated outcome quantiles.
}
\description{
Calculate quantiles of model outcome variables
}
\keyword{internal}
