% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.r
\docType{data}
\name{wvs}
\alias{wvs}
\title{World Values Survey Aggregate Data}
\format{
A data frame with 162 rows and 26 variables
\describe{
  \item{country}{Country of respondent residence.}
  \item{wave}{Wave of the survey.}
  \item{year}{Year of the survey.}
  \item{pct_high_rel_imp}{Religious importance is coded as Very, Rather, Not very or Not at all important
  in the individual data.  This variable is the proportion of respondents who indicated Very or Rather.}
  \item{pct_female}{Proportion of observations identifying as female.}
  \item{mean_lr}{Left-right self-placement is coded on a 1 (Left) to 10 (Right) scale in the individual
  data.  The \code{mean_lr} variable is the country-wave average of left-right self-placement.}
  \item{pct_less_secondary, pct_secondary, pct_some_univ, pct_univ_degree}{In the individual data, education is coded as
  Less than secondary, Secondary complete, Some university and University degree or more.  In the aggregate
  data, we calculate the proportion of observations in each category.}
  \item{pct_low_income, pct_mid_income, pct_high_income}{In the individual data, income is coded in decies (i.e., a 1-10 scale).
  In the aggregate data, we calculate the proportion of observations in categories 1-3 (Low), 4-7 (Middle) and 8-10 (High)
  categories.}
  \item{moral}{In the individual data, we created an additive scale of variables about how justifiable
  the following actions are: Illegally claiming government benefits, Avoiding a fare on public transport,
  Cheating on taxes, Accepting a bribe, Homosexuality, Divorce, Abortion, Prostitution, Euthanasia,
  Suicide on a scale from 1 (Never justifiable) to 10 (Always Justifiable).  In the aggregate data,
  we calculate the country-wave average of this scale.}
  \item{sacsecval}{Secular Values - opposite of traditional values wherein religion, parent-child
  ties, deference to authority and traditional family values are paramount. In the aggregate data, we take the
  country-wave average of this scale.}
  \item{secpay}{Imagine two secretaries, of the same age, doing practically the same job. One finds out that
   the other earns considerably more than she does. The better paid secretary, however, is quicker,
   more efficient and more reliable at her job. In your opinion, is it fair or not fair that one secretary
   is paid more than the other? The \code{secpay} variable is the proportion of people in each country indicating
   that the pay discrepancy is unfair.}
  \item{resemaval}{Emancipative Values - preference for gender and racial equality, liberty and personal autonomy.
  In the aggregate data, we take the country-wave average of this scale.}
  \item{rgdpe}{Expenditure-side real GDP at chained PPPs (in mil. 2017US$).
  Useful for making cross-country/cross-time comparisons of relative living standards.
  Obtained from Penn World Tables.}
  \item{rel_soc}{Dummy variable indicating places where at least 75% of 
  respondents identified religion as being important.}
  \item{pop}{Population in Millions, obtained from Penn World Tables.}
  \item{gdp_cap}{GDP/capita: \code{rgdpe}/\code{pop}.}
  \item{gini_disp}{Gini coefficient in terms of disposable income from the SWIID.}
  \item{gini_mkt}{Gini coefficient in terms of market prices from the SWIID.}
  \item{polrt}{Measure of the violation of political rights from the Freedom in the World Project.
  Coded on a scale from 1 (fewest violations) to 7 (most violations).}
  \item{civlib}{Measure of the violation of civil liberties from the Freedom in the World Project.
  Coded on a scale from 1 (fewest violations) to 7 (most violations).}
  \item{democrat}{Using the freedom status variable, we code a country as a democracy
  if in the past 15 years it was always at least partly free and was free for at least
  50 percent of the time.  This follows the work of Weakliem et. al. (2005).}
  \item{civ}{Categories defining the civilization in which each country belongs.
  Other=0, African=1, Buddhist=2, Hindu=3, Islamic=4, Japanese=5, Latin American=6, Orthodox=7,
  Siinic=8, Western=9.}
}
}
\description{
A subset of data from the second thorugh fifth waves of the World Values Survey.
}
\details{
We started with waves 2 (Inglehart et. al., 2014a), 3 (Inglehart et. al., 2014b),
4 (Inglehart et. al., 2014c) and 5 (Inglehart et. al., 2014d) of the World Values Survey (WVS).
The WVS is a cross-national survey effort aimed at describing the character of value systems
around the globe.  From each survey, we capture country and survey year, several demographic
variables (Religious Importance, fairness, left-right self-placement, education, income, sex and age)
along with some values scales (emancipative values and secular values).  We also capture several
questions about the extent to which several controversial actions are morally justifiable.
We add data from several other projects to these data.  To measure inequality, we use the Standardized
World Income Inequality Data (Solt, 2020).  From this dataset, we capture the Gini Coefficient (both in disposable
income and market income, though we tend to use the former in models).  We obtain GDP and population data
from the Penn World Tables version 10 (Feenstra et. al., 2015).  We gather data on political rights, civil liberties
and freedom status from the Freedom in the World Project (Freedom House, 2020).  We use the civilizations
codes from Henderson and Tucker (2001), which were used to test Huntington’s (1996) argument about the “clash of civilizations”.
Finally, we get the human development index (HDI) from the United Nations Development Programme (2020).
The combined dataset has 237,787 individual observations nested within 84 countries. Most countries appear in
only one or two waves (65), but nine appear in three waves and 10 in four waves.

We aggregate the variables in the individual dataset by country-wave to produce a more manageable data set.
The aggregate dataset has 162 rows and 38 variables.  The variables are as follows:
}
\references{
Feenstra, Robert C., Robert Inklaar and Marcel P. Timmer (2015), "The Next Generation of the Penn World Table" American Economic Review, 105(10), 3150-3182, available for download at \url{https://www.rug.nl/ggdc/productivity/pwt/}.

Freedom House.  (2020).  Freedom in the World 2020.  New York: Freedom House.

Henderson, Errol A. and Richard Tucker. 2001. "Clear and Present Strangers: The Clash of Civilizations and International Conflict." International Studies Quarterly, 45(2):317–338.

Inglehart, R., C. Haerpfer, A. Moreno, C. Welzel, K. Kizilova, J. Diez-Medrano, M. Lagos, P. Norris, E. Ponarin & B. Puranen et al. (eds.). 2014a. World Values Survey: Round Two - Country-Pooled Datafile Version: \url{https://www.worldvaluessurvey.org/WVSDocumentationWV2.jsp}. Madrid: JD Systems Institute.

Inglehart, R., C. Haerpfer, A. Moreno, C. Welzel, K. Kizilova, J. Diez-Medrano, M. Lagos, P. Norris, E. Ponarin & B. Puranen et al. (eds.). 2014b. World Values Survey: Round Three - Country-Pooled Datafile Version: \url{https://www.worldvaluessurvey.org/WVSDocumentationWV3.jsp}. Madrid: JD Systems Institute.

Inglehart, R., C. Haerpfer, A. Moreno, C. Welzel, K. Kizilova, J. Diez-Medrano, M. Lagos, P. Norris, E. Ponarin & B. Puranen et al. (eds.). 2014c. World Values Survey: Round Four - Country-Pooled Datafile Version: \url{https://www.worldvaluessurvey.org/WVSDocumentationWV4.jsp}. Madrid: JD Systems Institute.

Inglehart, R., C. Haerpfer, A. Moreno, C. Welzel, K. Kizilova, J. Diez-Medrano, M. Lagos, P. Norris, E. Ponarin & B. Puranen et al. (eds.). 2014d. World Values Survey: Round Five - Country-Pooled Datafile Version: \url{https://www.worldvaluessurvey.org/WVSDocumentationWV5.jsp}. Madrid: JD Systems Institute.

Solt, Frederick. 2020. "Measuring Income Inequality Across Countries and Over Time: The Standardized World Income Inequality Database." Social Science Quarterly 101(3):1183-1199. SWIID Version 9.0, October 2020.
}
\keyword{datasets}
