% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psrwe_ps.R
\name{rwe_ps_match}
\alias{rwe_ps_match}
\title{PS matching}
\usage{
rwe_ps_match(dta_cur, dta_ext, ratio = 3, ps_fml = NULL, v_covs = "V1")
}
\arguments{
\item{dta_cur}{current study dataframe}

\item{dta_ext}{external data source dataframe}

\item{ratio}{matching ratio}

\item{ps_fml}{Propensity score formula. If null, all covariates will be
included in the PS model in a linear form.}

\item{v_covs}{Vector of column names corresponding to covariates}
}
\value{
A matrix with two columns. Column \code{pid}: id in dta_cur; Column
    \code{match_id}: matched id from dta_ext.
}
\description{
Match patients in external data source with patients in current study based
on PS using nearest neighbor method
}
\examples{
dta_cur <- ex_dta[which(ex_dta$Group == "current"), ]
dta_ext <- ex_dta[which(ex_dta$Group != "current"), ]
rwe_ps_match(dta_cur, dta_ext, v_covs = paste("V", 1:7, sep = ""),
             ratio = 2)

}
