% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psrwe_complikel.R
\name{psrwe_compl}
\alias{psrwe_compl}
\title{PS-Integrated Composite Likelihood Estimation}
\usage{
psrwe_compl(
  dta_psbor,
  v_outcome = "Y",
  outcome_type = c("continuous", "binary"),
  ...
)
}
\arguments{
\item{dta_psbor}{A class \code{PSRWE_BOR} object generated by
\code{\link{psrwe_borrow}}.}

\item{v_outcome}{Column name corresponding to the outcome.}

\item{outcome_type}{Type of outcomes: \code{continuous} or \code{binary}.}

\item{...}{Parameters for \code{rwe_cl}}
}
\value{
A data frame with class name \code{PSRWE_RST}. It contains the
    composite estimation of the mean for each stratum as well as the
    jackknife estimation for each subject. The results should be further
    summarized by its S3 method \code{summary}.
}
\description{
Estimate the mean of the outcome based on PS-integrated composite likelihood
approach. Variance is estimated by Jack-Knife method. Applies to the case
when there is only one external data source.
}
\examples{
data(ex_dta)
dta_ps <- psrwe_est(ex_dta,
       v_covs = paste("V", 1:7, sep = ""),
       v_grp = "Group",
       cur_grp_level = "current")
ps_borrow <- psrwe_borrow(total_borrow = 30, dta_ps)
rst       <- psrwe_compl(ps_borrow, v_outcome = "Y_Con")
rst

}
