% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.R
\name{fValueString}
\alias{fValueString}
\title{fValueString}
\usage{
fValueString(aovObj, effect)
}
\arguments{
\item{aovObj}{Output from aov or ezANOVA (NB. ezANOVA must be called with detailed = TRUE)}

\item{effect}{The effect within the ANOVA table to return}
}
\value{
character
}
\description{
Returns required Latex formatted string for \emph{F}(df1, df2) = XXX
for R/knitr integration. For example, \emph{F}(1, 23) = 3.45.
Returns values to 2 sig decimal places.
}
\examples{
# Example 1:
# create dataframe and add data with 2(Comp: comp vs. incomp) and 2(Side: left vs. right)
dat <- createDF(nVP = 20, nTrl = 1,
                design = list("Comp" = c("comp", "incomp"),
                              "Side" = c("left", "right")))

dat <- addDataDF(dat, RT = list("Comp:Side comp:left"    = c(500, 150, 100),
                                "Comp:Side comp:right"   = c(500, 150, 100),
                                "Comp:Side incomp:left"  = c(520, 150, 100),
                                "Comp:Side incomp:right" = c(520, 150, 100)))

# or using ezANOVA
library(ez)
aovRT <- ezANOVA(dat, dv=.(RT), wid = .(VP), within = .(Comp, Side),
                 return_aov = TRUE, detailed = TRUE)
aovRT <- aovTable(aovRT)

fString <- fValueString(aovRT, "Comp")
fString <- fValueString(aovRT, "Comp:Side")

}
