% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.R
\name{aovDispMeans}
\alias{aovDispMeans}
\title{aovDispMeans}
\usage{
aovDispMeans(aovObj, value = "value", caption = sys.call())
}
\arguments{
\item{aovObj}{Output from aov or ezANOVA  (NB. ezANOVA must be called with \"return_aov = TRUE\"")}

\item{value}{String for column name}

\item{caption}{Required for heading}
}
\description{
Displays marginal means from model.tables in the command window.
}
\examples{
# Example 1:
# create dataframe
dat <- createDF(nVP = 50, nTrl = 1,
                design = list("Comp" = c("comp", "incomp")))

dat <- addDataDF(dat, RT = list("Comp comp"   = c(500, 100, 100),
                                "Comp incomp" = c(520, 100, 100)))

aovRT <- aov(RT ~ Comp + Error(VP/(Comp)), dat)
aovDispMeans(aovRT)

# or with ezANOVA
library(ez)
aovRT <- ezANOVA(dat, dv=.(RT), wid = .(VP), within = .(Comp),
                 return_aov = TRUE, detailed = TRUE)
aovRT <- aovTable(aovRT)
aovDispMeans(aovRT)

}
