% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/truncate.R
\name{truncate_dist}
\alias{truncate_dist}
\title{Truncation function for normal distributions (truncates both mean and variance)}
\usage{
truncate_dist(a = -Inf, b = Inf, mean = 0, sd = 1)
}
\arguments{
\item{a}{Quantile (i.e., cut score) below which scores should be censored from the distribution.}

\item{b}{Quantile (i.e., cut score) above which scores should be censored from the distribution.}

\item{mean}{Scalar mean or vector of means.}

\item{sd}{Scalar standard deviation or vector of standard deviations.}
}
\value{
A matrix of truncated means (column 1) and truncated variances (column 2).
}
\description{
This function computes the mean and variance of a normal distributions that has been truncated at one or both ends.
}
\examples{
truncate_dist(a = -1, b = 3, mean = 0, sd = 1)
truncate_dist(a = 1, b = Inf, mean = 0, sd = 1)
truncate_dist(a = c(-1, 1), b = c(3, Inf), mean = 0, sd = 1)
}
\keyword{univar}
