% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correct_r.R
\name{correct_r_coarseness}
\alias{correct_r_coarseness}
\title{Correct correlations for scale coarseness}
\usage{
correct_r_coarseness(r, kx = NULL, ky = NULL, n = NULL, dist_x = "norm",
  dist_y = "norm", bin_value_x = c("median", "mean", "index"),
  bin_value_y = c("median", "mean", "index"), width_x = 3, width_y = 3,
  lbound_x = NULL, ubound_x = NULL, lbound_y = NULL, ubound_y = NULL,
  index_values_x = NULL, index_values_y = NULL)
}
\arguments{
\item{r}{Observed correlation.}

\item{kx, ky}{Number of scale points used to measure the x and y variables. Set to NULL to treat as continuously measured.}

\item{n}{Optional sample size.}

\item{dist_x, dist_y}{Assumed latent distribution of the x and y variables.}

\item{bin_value_x, bin_value_y}{Are the scale points used to measure the of the x and y variables assumed to represent bin medians, means, or index values?}

\item{width_x, width_y}{For symmetrically distributed variables, how many standard deviations above/below the latent mean should be be used for the latent variable range to make the correction? (Note: Setting \code{width} > 3 produces erratic results.) The latent variable range can alternatively be set using \code{lbound} and \code{ubound}.}

\item{lbound_x, lbound_y}{What lower bound of the range for the latent x and y variables should be used to make the correction? (Note: For normally distributed variables, setting \code{lbound} < -3 produces erratic results.)}

\item{ubound_x, ubound_y}{What upper bound of the range for the latent x and y variables should be used to make the correction? (Note: For normally distributed variables, setting \code{ubound} > 3 produces erratic results.)}

\item{index_values_x, index_values_y}{Optional. If \code{bin_value} = "index", the bin index values. If unspecified, values 1:k are used.}
}
\value{
Vector of correlations corrected for scale coarseness (if \code{n} is supplied, corrected error variance and adjusted sample size is also reported).
}
\description{
Correct correlations for scale coarseness
}
\examples{
correct_r_coarseness(r = .35, kx = 5, ky = 4, n = 100)
correct_r_coarseness(r = .35, kx = 5, n = 100)
correct_r_coarseness(r = .35, kx = 5, ky = 4, n = 100, dist_x="unif", dist_y="norm")
}
\references{
Aguinis, H., Pierce, C. A., & Culpepper, S. A. (2009).
Scale coarseness as a methodological artifact:
Correcting correlation coefficients attenuated from using coarse scales.
\emph{Organizational Research Methods, 12}(4), 623–652. \url{https://doi.org/10.1177/1094428108318065}

Schmidt, F. L., & Hunter, J. E. (2015).
\emph{Methods of meta-analysis: Correcting error and bias in research findings} (3rd ed.).
Thousand Oaks, CA: SAGE. \url{https://doi.org/10/b6mg}. pp. 287-288.

Peters, C. C., & Van Voorhis, W. R. (1940).
\emph{Statistical procedures and their mathematical bases}.
New York, NY: Mcgraw-Hill. \url{https://doi.org/10.1037/13596-000}. pp. 393–399.
}
