% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_error.R
\name{var_error_rel}
\alias{var_error_rel}
\title{Estimate the error variance of reliability estimates}
\usage{
var_error_rel(rel, n)
}
\arguments{
\item{rel}{Vector of reliability estimates.}

\item{n}{Vector of sample sizes.}
}
\value{
A vector of sampling-error variances.
}
\description{
Estimate the error variance of reliability estimates
}
\details{
The sampling variance of a reliability coefficient is:

\deqn{var_{e}=\frac{4r_{XX}(1-r_{XX})^{2}}{n-1}}{var_e = 4 * rxx * (1 - rxx)^2 / (n - 1)}
}
\examples{
var_error_rel(rel = .8, n = 100)
}
\references{
Dahlke, J. A., & Wiernik, B. M. (2017).
\emph{One of these artifacts is not like the others: New methods to account for the unique implications of indirect range-restriction corrections in organizational research}.
Unpublished manuscript.
}
