% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_error.R
\name{var_error_q}
\alias{var_error_q}
\title{Estimate the error variance of square roots of reliability estimates}
\usage{
var_error_q(q, n)
}
\arguments{
\item{q}{Vector of of square roots of reliability estimates.}

\item{n}{Vector of sample sizes.}
}
\value{
A vector of sampling-error variances.
}
\description{
Estimate the error variance of square roots of reliability estimates
}
\details{
The sampling variance of the square root of a reliability coefficient is:

\deqn{var_{e}=\frac{(1-q_{X}^{2})^{2}}{n-1}}{var_e = (1 - qx^2)^2 / (n - 1)}
}
\examples{
var_error_q(q = .8, n = 100)
}
\references{
Dahlke, J. A., & Wiernik, B. M. (2017).
\emph{One of these artifacts is not like the others: New methods to account for the unique implications of indirect range-restriction corrections in organizational research}.
Unpublished manuscript.
}
