% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correct_r.R
\name{correct_r_bvirr}
\alias{correct_r_bvirr}
\title{Correct correlations for bivariate indirect range restriction and measurement error}
\usage{
correct_r_bvirr(rxyi, ux = 1, uy = 1, rxx = 1, ryy = 1,
  ux_observed = TRUE, uy_observed = TRUE, rxx_restricted = TRUE,
  ryy_restricted = TRUE, sign_rxz = 1, sign_ryz = 1, n = NULL,
  conf_level = 0.95, correct_bias = FALSE)
}
\arguments{
\item{rxyi}{Vector of observed correlations.}

\item{ux}{Vector of u ratios for X.}

\item{uy}{Vector of u ratios for Y.}

\item{rxx}{Vector of reliability coefficients for X.}

\item{ryy}{Vector of reliability coefficients for Y.}

\item{ux_observed}{Logical vector in which each entry specifies whether the corresponding ux value is an observed-score u ratio (\code{TRUE}) or a true-score u ratio. All entries are \code{TRUE} by default.}

\item{uy_observed}{Logical vector in which each entry specifies whether the corresponding uy value is an observed-score u ratio (\code{TRUE}) or a true-score u ratio. All entries are \code{TRUE} by default.}

\item{rxx_restricted}{Logical vector in which each entry specifies whether the corresponding rxx value is an incumbent reliability (\code{TRUE}) or an applicant reliability. All entries are \code{TRUE} by default.}

\item{ryy_restricted}{Logical vector in which each entry specifies whether the corresponding rxx value is an incumbent reliability (\code{TRUE}) or an applicant reliability. All entries are \code{TRUE} by default.}

\item{sign_rxz}{Vector of signs of the relationships between X variables and the selection mechanism.}

\item{sign_ryz}{Vector of signs of the relationships between Y variables and the selection mechanism.}

\item{n}{Optional vector of sample sizes associated with the rxyi correlations.}

\item{conf_level}{Confidence level to define the width of the confidence interval (default = .95).}

\item{correct_bias}{Logical argument that determines whether to correct error-variance estimates for small-sample bias in correlations (\code{TRUE}) or not (\code{FALSE}).
For sporadic corrections (e.g., in mixed artifact-distribution meta-analyses), this should be set to \code{FALSE}, the default).}
}
\value{
Data frame(s) of observed correlations (\code{rxyi}), operational range-restricted correlations corrected for measurement error in Y only (\code{rxpi}), operational range-restricted correlations corrected for measurement error in X only (\code{rtyi}), and range-restricted true-score correlations (\code{rtpi}),
range-corrected observed-score correlations (\code{rxya}), operational range-corrected correlations corrected for measurement error in Y only (\code{rxpa}), operational range-corrected correlations corrected for measurement error in X only (\code{rtya}), and range-corrected true-score correlations (\code{rtpa}).
}
\description{
Correct correlations for bivariate indirect range restriction and measurement error
}
\examples{
correct_r_bvirr(rxyi = .3, ux = .8, uy = .8, rxx = .8, ryy = .8,
     ux_observed = TRUE, uy_observed = TRUE, rxx_restricted = TRUE, ryy_restricted = TRUE)
correct_r_bvirr(rxyi = .3, ux = .8, uy = .8, rxx = .8, ryy = .8,
     ux_observed = TRUE, uy_observed = TRUE, rxx_restricted = TRUE, ryy_restricted = TRUE, n = 100)
}
\references{
Le, H., Oh, I.-S., Schmidt, F. L., & Wooldridge, C. D. (2016).
Correction for range restriction in meta-analysis revisited: Improvements and implications for organizational research.
\emph{Personnel Psychology, 69}(4), 975–1008. \url{https://doi.org/10.1111/peps.12122}
}
\keyword{internal}
