% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mix_matrix.R
\name{unmix_matrix}
\alias{unmix_matrix}
\title{Estimate average within-group covariance matrices from a mixture covariance matrix}
\usage{
unmix_matrix(sigma_mat, mu_mat, p_vec, N = Inf, group_names = NULL,
  var_names = NULL)
}
\arguments{
\item{sigma_mat}{Mixture covariance matrix.}

\item{mu_mat}{Matrix of mean parameters, with groups on the rows and variables on the columns.}

\item{p_vec}{Vector of proportion of cases in each group.}

\item{N}{Optional total sample size across all groups (used to compute unbiased covariance estimates).}

\item{group_names}{Optional vector of group names.}

\item{var_names}{Optional vector of variable names.}
}
\value{
List of within-group covariances and means.
}
\description{
Estimate average within-group covariance matrices from a mixture covariance matrix
}
\examples{
out <- unmix_matrix(sigma_mat = reshape_vec2mat(.5, order = 2),
                    mu_mat = rbind(c(0, 0), c(.5, 1)),
                    p_vec =  c(.3, .7), N = 100)

## Result of unmix_matrix:
out

## Simulated data reproduce the total parameter matrix:
dat <- NULL
for(i in 1:2){
     dat <- rbind(dat, cbind(group = i,
                             data.frame(MASS::mvrnorm(n = round(out$p_group[i] * out$N),
                                                      mu = out$means_raw[i,],
                                                      Sigma = out$cov_group_unbiased[[i]],
                                                      empirical = TRUE))))
}
cov(dat[,-1])
}
