% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_forest}
\alias{plot_forest}
\title{Create forest plots}
\usage{
plot_forest(ma_obj, analyses = "all", match = c("all", "any"),
  case_sensitive = TRUE, show_filtered = FALSE,
  ma_facetname = "Summary", facet_levels = NULL, conf_level = 0.95,
  conf_method = "t", x_limits = NULL, x_breaks = NULL,
  x_lab = NULL, y_lab = "Reference")
}
\arguments{
\item{ma_obj}{Meta-analysis object.}

\item{analyses}{Which analyses to extract? Can be either \code{"all"} to extract references for all meta-analyses in the object (default) or a list containing arguments for [filter_ma].}

\item{match}{Should extracted meta-analyses match all (default) or any of the criteria given in \code{analyses}?}

\item{case_sensitive}{Logical scalar that determines whether character values supplied in \code{analyses} should be treated as case sensitive (\code{TRUE}, default) or not (\code{FALSE}).}

\item{show_filtered}{Logical scalar that determines whether the meta-analysis object given in the output should be the modified input object (\code{FALSE}, default) or the filtered object (\code{TRUE}).}

\item{ma_facetname}{Label to use for meta-analysis results in the \code{facet_grid()} function from \code{ggplot2}.}

\item{facet_levels}{Order in which moderator levels should be displayed.}

\item{conf_level}{Confidence level to define the width of the confidence interval (default = .95).}

\item{conf_method}{Distribution to be used to compute the width of confidence intervals. Available options are "t" for \emph{t} distribution or "norm" for normal distribution.}

\item{x_limits}{Span of the X values to be plotted.}

\item{x_breaks}{Breaks for the X values to be plotted.}

\item{x_lab}{Label to use for the X axis.}

\item{y_lab}{Label to use for the Y axis.}
}
\value{
A list of forest plots.
}
\description{
Create forest plots
}
\examples{
\dontrun{
ma_obj <- ma_r(ma_method = "ic", rxyi = rxyi, n = n, rxx = rxxi, ryy = ryyi,
               construct_x = x_name, construct_y = y_name, sample_id = sample_id,
               moderators = moderator, data = data_r_meas_multi)
plot_forest(ma_obj = ma_obj)
plot_forest(ma_obj = ma_obj, analyses = list(pair_id = 2))
plot_forest(ma_obj = ma_obj, analyses = list(pair_id = 1), show_filtered = TRUE)

## d values
ma_obj <- ma_d(ma_method = "ic", d = d, n1 = n1, n2 = n2, ryy = ryyi,
               construct_y = construct, sample_id = sample_id,
               data = data_d_meas_multi)
plot_forest(ma_obj = ma_obj)
plot_forest(ma_obj = ma_obj, analyses = list(pair_id = 2))
plot_forest(ma_obj = ma_obj, analyses = list(pair_id = 1, analysis_id = 1), show_filtered = TRUE)
}
}
\author{
Based on code by John Sakaluk
}
