% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_ad_wrappers.R
\name{create_ad_group}
\alias{create_ad_group}
\title{Generate an artifact distribution object for a dichotomous grouping variable.}
\usage{
create_ad_group(
  ad_type = c("tsa", "int"),
  rGg = NULL,
  n_rGg = NULL,
  wt_rGg = n_rGg,
  pi = NULL,
  pa = NULL,
  n_pi = NULL,
  n_pa = NULL,
  wt_p = n_pi,
  mean_rGg = NULL,
  var_rGg = NULL,
  k_rGg = NULL,
  mean_n_rGg = NULL,
  var_unbiased = TRUE,
  ...
)
}
\arguments{
\item{ad_type}{Type of artifact distribution to be computed: Either "tsa" for Taylor series approximation or "int" for interactive.}

\item{rGg}{Vector of incumbent reliability estimates.}

\item{n_rGg}{Vector of sample sizes associated with the elements of \code{rGg.}}

\item{wt_rGg}{Vector of weights associated with the elements of \code{rGg} (by default, sample sizes will be used as weights if provided).}

\item{pi}{Vector of incumbent/sample proportions of members in one of the two groups being compared (one or both of \code{pi}/\code{pa} can be vectors - if both are vectors, they must be of equal length).}

\item{pa}{Vector of applicant/population proportions of members in one of the two groups being compared (one or both of \code{pi}/\code{pa} can be vectors - if both are vectors, they must be of equal length).}

\item{n_pi}{Vector of sample sizes associated with the elements in \code{pi}.}

\item{n_pa}{Vector of sample sizes associated with the elements in \code{pa}.}

\item{wt_p}{Vector of weights associated with the collective element pairs in \code{pi} and pa.}

\item{mean_rGg}{Vector that can be used to supply the means of externally computed distributions of correlations between observed and latent group membership.}

\item{var_rGg}{Vector that can be used to supply the variances of externally computed distributions of correlations between observed and latent group membership.}

\item{k_rGg}{Vector that can be used to supply the number of studies included in externally computed distributions of correlations between observed and latent group membership.}

\item{mean_n_rGg}{Vector that can be used to supply the mean sample sizes of externally computed distributions of correlations between observed and latent group membership.}

\item{var_unbiased}{Logical scalar determining whether variance should be unbiased (\code{TRUE}) or maximum-likelihood (\code{FALSE}).}

\item{...}{Further arguments.}
}
\value{
Artifact distribution object (matrix of artifact-distribution means and variances) for use in artifact-distribution meta-analyses.
}
\description{
This function generates artifact-distribution objects containing either interactive or Taylor series artifact distributions for dichotomous group-membership variables.
Use this to create objects that can be supplied to the \code{ma_r_ad} and \code{ma_d_ad} functions to apply psychometric corrections to barebones meta-analysis objects via artifact distribution methods.

Allows consolidation of observed and estimated artifact information by cross-correcting artifact distributions and forming weighted artifact summaries.
}
\examples{
## Example artifact distribution for a dichotomous grouping variable:
create_ad_group(rGg = c(.8, .9, .95), n_rGg = c(100, 200, 250),
                mean_rGg = .9, var_rGg = .05,
                k_rGg = 5, mean_n_rGg = 100,
                pi = c(.6, .55, .3), pa = .5, n_pi = c(100, 200, 250), n_pa = c(300, 300, 300),
                var_unbiased = TRUE)
                
create_ad_group(ad_type = "int", rGg = c(.8, .9, .95), n_rGg = c(100, 200, 250),
                mean_rGg = .9, var_rGg = .05,
                k_rGg = 5, mean_n_rGg = 100,
                pi = c(.6, .55, .3), pa = .5, n_pi = c(100, 200, 250), n_pa = c(300, 300, 300),
                var_unbiased = TRUE)
}
